(ns user
  (:require
   [weasel.repl :as ws-repl]
   [clairvoyant.core :as trace :include-macros true]))

(ws-repl/connect "ws://localhost:9091" :verbose true)

(def foo
  (let [m {:foo "bar"}]
    (trace/trace-forms
     {:tracer trace/default-tracer}
     (reify
       ILookup
       (-lookup [_ k]
         (get m k))
       (-lookup [_ k not-found]
         (get m k not-found))))))

(def bar
  (trace/trace-forms
   {:tracer trace/default-tracer}
   (fn
     ([x] x)
     ([x y]
        {:pre [(even? x) (odd? y)]}
        (+ x y)))))

(trace/trace-forms
 {:tracer trace/default-tracer}
 (defn quux
   [x y] (+ y x)))

(defmulti baz :tag
  :default ::default)

(trace/trace-forms
 {:tracer trace/default-tracer}

 (defmethod baz :span [{:keys [content]}]
   content)

 (defmethod baz ::default [_]
   ":("))

(:foo foo)
(:bar foo "baz")

(bar 1)

(bar 2 1)

(trace/trace-forms
 {:tracer trace/default-tracer}
 (defn bar [x] x))
(quux 2 1)

(baz {:tag :span :content "lmao"})
(baz {:tag :h1 :content "lol"})
