(ns user
  (:require
   [weasel.repl :as ws-repl]
   [clairvoyant.core :as trace :include-macros true]))

#_
(ws-repl/connect "ws://localhost:9091" :verbose true)

(def x 10)

(defmulti frobble :tag
  :default ::default)

(trace/trace-forms
 {:tracer trace/default-tracer}

 (defmethod frobble :bar [tag]
   tag)

 (defmethod frobble ::default [tag]
   tag)

 (defn hello [m1 m2 & ms]
   (:foo m1)
   (into [(:foo m1)
          (:foo m2)] (map :foo ms)))

 (extend-type object
   ISeqable
   (-seq [this]
     (for [k (Object.keys this)]
       [k (aget this k)])))

 (def some-obj
   (let [o #js{:foo "bar"}]
     (reify
       ILookup
       (-lookup [this k]
         (aget o (name k)))

       (-lookup [this k not-found]
         (or (aget o (name k)) not-found)))))

 (defn add [x y]
   {:pre [(even? x) (odd? y)]}
   (+ x y)))

(frobble {:tag :bar})
(frobble {:tag :baz})

(hello {:foo "bar"}
       {:foo "bar"}
       {:foo "bar"})

(seq #js {:foo "bar" :bar "baz"})
(seq #js {:cat "meow" :dog "bar"})

(:foo some-obj)

#_(add 10 2)

(trace/trace-forms
 {:tracer trace/default-tracer}
 (defn dip [x]
   (fn [y]
     (let [a 10
           b 20
           c (+ a b)]
       (+ y x c)))))

((dip 20) 30)
