(ns user
  (:require
   [weasel.repl :as ws-repl]
   [clairvoyant.core :as trace :include-macros true]))

(ws-repl/connect "ws://localhost:9091" :verbose true)

(def x 10)

(trace/trace-forms
 {:tracer trace/default-tracer}

 (defn hello [m1 m2 & ms]
   (:foo m1)
   (into [(:foo m1)
          (:foo m2)] (map :foo ms)))

 (extend-type object
   ISeqable
   (-seq [this]
     (for [k (Object.keys this)]
       [k (aget this k)])))

 (def some-obj
   (let [o #js{:foo "bar"}]
     (reify
       ILookup
       (-lookup [this k]
         (aget o k))

       (-lookup [this k not-found]
         (or (aget o k) not-found))))))


(seq #js {:foo "bar" :bar "baz"})

(hello {:foo "bar"}
       {:foo "bar"}
       {:foo "bar"})

(:foo some-obj)

