
(def ^:const itraq-8-plex [113.1078 114.1112
                           115.1082 116.1116
                           117.1149 118.1120
                           119.1153 121.1220])

;; itraq

(defn itraq-peaks
  [spectra & {:keys [window labels] :or {window 0.1 labels itraq-8-plex}}]
  (let [h {113 0 114 0 115 0 116 0 117 0 118 0 119 0 121 0}]
    (->> (map #(vector %1 %2) (mz-array spectra) (intensity-array spectra))
         (remove #(not (some (fn [x] (and (>= (first %) (- x window))
                                          (<= (first %) (+ x window))))
                             labels)))
         (group-by #(let [f (int (first %))]
                      (if (> (+ 0.5 (first %)) (+ f 1))
                        (+ 1 f) f)))
         (map (fn [[k v]] (vector k (reduce + (map second v)))))
         (into {})
         (merge h))))
