# speccy

Speccy provides a simple composable interface to mzML and MGF files
that store data acquired during mass spectrometer experiments.

## Installation

Available from [Clojars](https://clojars.org/speccy). For the current
version add the following to your project.clj file:

```clojure
[speccy "0.1.4"]
```

To use in your namespace:

```clojure
(ns my-app.core
  (:require [speccy.core :refer :all]
            [speccy.mzml :refer :all]
	    [speccy.mgf :refer :all]))
```

Include mzml or mgf (or both) depending on what files you want to work
with.

## Usage

Speccy provides readers for mzML and MGF files on which `spectra-seq`
can be called. This function works much like the Clojure function
`line-seq` except that it returns a lazy-list of spectra records from
a file.

Using an mzML file as an example:

```clojure
user> (def mz-file (init-mzml-file "/path/test.mzML" :indexing false))
#'user/tf
user> (with-open [r (spectra-reader mz-file)]
        (class (first (spectra-seq r))))
speccy.mzml.mzmlSpectra
```

There are a load of accessors for accessing data that will be
documented in future releases.

## License

Copyright © 2014 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
