(ns spand.config
  "As these are not secrets, revealing details about dev and staging config to prod clients doesn't
   seem like a big deal. If we see it having potential to become an issue then we will take steps to
   address."
  (:require [spand.config.env
              :refer [env-name]]))

(defn- assoc-authority
  "'Authority' is what you call a hostname + port."
  [config]
  (assoc config :authority
    (str (:host config)
         (when (not= 80 (:port config))
           (str ":" (:port config))))))

(def ^:private default-config
  {})

(def ^:private dev-config
  {:host "localhost"
   :port 8080})

(def ^:private staging-config
  {:host "staging.spand.io"})

(def ^:private prod-config
  {:cljs-path "js/main.js"
   :host      "spand.io"
   :port      80})

(def ^:private all-config
  {:dev     (merge default-config prod-config staging-config dev-config)
   :staging (merge default-config prod-config staging-config)
   :prod    (merge default-config prod-config)})

(def config (-> all-config (get env-name) assoc-authority))
