/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class TofuRenderVisitor
extends RenderVisitor {
    private final Map<String, SoyTofuPrintDirective> soyTofuDirectivesMap;

    protected TofuRenderVisitor(Map<String, SoyTofuPrintDirective> map, EvalVisitor.EvalVisitorFactory evalVisitorFactory, RenderVisitor.RenderVisitorFactory renderVisitorFactory, StringBuilder stringBuilder, @Nullable TemplateRegistry templateRegistry, @Nullable SoyMapData soyMapData, @Nullable SoyMapData soyMapData2, @Nullable Deque<Map<String, SoyData>> deque, @Nullable Set<String> set, @Nullable SoyMsgBundle soyMsgBundle, @Nullable SoyCssRenamingMap soyCssRenamingMap) {
        super(null, evalVisitorFactory, renderVisitorFactory, stringBuilder, templateRegistry, soyMapData, soyMapData2, deque, set, soyMsgBundle, soyCssRenamingMap);
        this.soyTofuDirectivesMap = map;
    }

    @Override
    protected String applyDirective(String string, SoyData soyData, List<SoyData> list, PrintNode printNode) {
        SoyTofuPrintDirective soyTofuPrintDirective = this.soyTofuDirectivesMap.get(string);
        if (soyTofuPrintDirective == null) {
            throw new RenderException("Failed to find Soy print directive with name '" + string + "'" + " (tag " + printNode.toSourceString() + ")");
        }
        if (!soyTofuPrintDirective.getValidArgsSizes().contains(list.size())) {
            throw new RenderException("Print directive '" + string + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
        }
        return soyTofuPrintDirective.applyForTofu(soyData, list);
    }
}

