/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class TofuEvalVisitor
extends EvalVisitor {
    private final Map<String, SoyTofuFunction> soyTofuFunctionsMap;

    protected TofuEvalVisitor(@Nullable Map<String, SoyTofuFunction> map, @Nullable SoyMapData soyMapData, @Nullable SoyMapData soyMapData2, Deque<Map<String, SoyData>> deque) {
        super(null, soyMapData, soyMapData2, deque);
        this.soyTofuFunctionsMap = map;
    }

    @Override
    protected SoyData computeFunction(String string, List<SoyData> list, FunctionNode functionNode) {
        SoyTofuFunction soyTofuFunction = this.soyTofuFunctionsMap.get(string);
        if (soyTofuFunction == null) {
            throw new RenderException("Failed to find Soy function with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
        }
        try {
            return soyTofuFunction.computeForTofu(list);
        }
        catch (Exception exception) {
            throw new RenderException("Error while computing function \"" + functionNode.toSourceString() + "\": " + exception.getMessage());
        }
    }
}

