/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import java.util.Map;
import javax.annotation.Nullable;

class NamespacedTofu
implements SoyTofu {
    private final BaseTofu baseTofu;
    private final String namespace;

    NamespacedTofu(BaseTofu baseTofu, String string) {
        Preconditions.checkNotNull((Object)baseTofu);
        this.baseTofu = baseTofu;
        Preconditions.checkArgument((string != null && string.length() > 0 ? 1 : 0) != 0);
        this.namespace = string;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public SoyTofu forNamespace(@Nullable String string) {
        if (string == null) {
            return this.baseTofu;
        }
        Preconditions.checkArgument((string.charAt(0) != '.' && string.charAt(string.length() - 1) != '.' ? 1 : 0) != 0, (Object)("Invalid namespace '" + string + "' (must not begin or end with a dot)."));
        return new NamespacedTofu(this.baseTofu, string);
    }

    @Override
    public boolean isCaching() {
        return this.baseTofu.isCaching();
    }

    @Override
    public void addToCache(@Nullable SoyMsgBundle soyMsgBundle, @Nullable SoyCssRenamingMap soyCssRenamingMap) {
        this.baseTofu.addToCache(soyMsgBundle, soyCssRenamingMap);
    }

    @Override
    public SoyTofu.Renderer newRenderer(SoyTemplateInfo soyTemplateInfo) {
        return this.baseTofu.newRenderer(soyTemplateInfo);
    }

    @Override
    public SoyTofu.Renderer newRenderer(String string) {
        return this.baseTofu.newRenderer(this.namespace + string);
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(soyTemplateInfo.getPartialName(), map, soyMsgBundle);
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo soyTemplateInfo, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(soyTemplateInfo.getPartialName(), soyMapData, soyMsgBundle);
    }

    @Override
    @Deprecated
    public String render(String string, @Nullable Map<String, ?> map, @Nullable SoyMsgBundle soyMsgBundle) {
        return this.render(string, map == null ? null : new SoyMapData(map), soyMsgBundle);
    }

    @Override
    @Deprecated
    public String render(String string, @Nullable SoyMapData soyMapData, @Nullable SoyMsgBundle soyMsgBundle) {
        Preconditions.checkArgument((string.charAt(0) == '.' ? 1 : 0) != 0);
        return this.baseTofu.render(this.namespace + string, soyMapData, soyMsgBundle);
    }
}

