/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class SwitchNode
extends AbstractParentCommandNode<SoyNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private final ExprRootNode<?> expr;

    public SwitchNode(int n, String string) throws SoySyntaxException {
        super(n, "switch", string);
        ExprRootNode<?> exprRootNode;
        try {
            exprRootNode = new ExpressionParser(string).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidExpr(tokenMgrError, string);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidExpr(parseException, string);
        }
        this.expr = exprRootNode;
    }

    protected SwitchNode(SwitchNode switchNode) {
        super(switchNode);
        this.expr = switchNode.expr.clone();
    }

    private SoySyntaxException createExceptionForInvalidExpr(Throwable throwable, String string) {
        return new SoySyntaxException("Invalid expression in 'switch' command text \"" + string + "\".", throwable);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_NODE;
    }

    public String getExprText() {
        return this.expr.toSourceString();
    }

    public ExprRootNode<?> getExpr() {
        return this.expr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.expr));
    }

    @Override
    public String getCommandText() {
        return this.expr.toSourceString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public SwitchNode clone() {
        return new SwitchNode(this);
    }
}

