/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyFileNode
extends AbstractParentSoyNode<TemplateNode>
implements SoyNode.SplitLevelTopNode<TemplateNode> {
    private final String delPackageName;
    private final String namespace;
    private final AutoescapeMode defaultAutoescapeMode;
    private String filePath;
    private String fileName;
    private static final Pattern CMD_TEXT_PATTERN = Pattern.compile("\\s* ([a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*) (\\s .*)?", 4);
    private static final AutoescapeMode DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE = AutoescapeMode.TRUE;
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("namespace", new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE.getAttributeValue()));

    public SoyFileNode(int n, @Nullable String string, @Nullable String string2) throws SoySyntaxException {
        super(n);
        if (string != null) {
            this.delPackageName = string.trim();
            if (!BaseUtils.isDottedIdentifier(this.delPackageName)) {
                throw new SoySyntaxException("Invalid delegate package name \"" + this.delPackageName + "\".");
            }
        } else {
            this.delPackageName = null;
        }
        String string3 = null;
        AutoescapeMode autoescapeMode = DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE;
        if (string2 != null) {
            Matcher matcher = CMD_TEXT_PATTERN.matcher(string2);
            if (matcher.matches()) {
                Map<String, String> map;
                string3 = matcher.group(1);
                String string4 = matcher.group(2);
                if (string4 != null && (map = ATTRIBUTES_PARSER.parse(string4 = string4.trim())).containsKey("autoescape")) {
                    autoescapeMode = AutoescapeMode.forAttributeValue(map.get("autoescape"));
                }
            } else {
                throw new SoySyntaxException("Invalid namespace command text \"" + string2 + "\".");
            }
        }
        this.namespace = string3;
        this.defaultAutoescapeMode = autoescapeMode;
        if (string3 == null) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        } else if (!BaseUtils.isDottedIdentifier(string3)) {
            throw new SoySyntaxException("Invalid namespace name \"" + string3 + "\".");
        }
    }

    protected SoyFileNode(SoyFileNode soyFileNode) {
        super(soyFileNode);
        this.delPackageName = soyFileNode.delPackageName;
        this.namespace = soyFileNode.namespace;
        this.defaultAutoescapeMode = soyFileNode.defaultAutoescapeMode;
        this.filePath = soyFileNode.filePath;
        this.fileName = soyFileNode.fileName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public String getDelPackageName() {
        return this.delPackageName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AutoescapeMode getDefaultAutoescapeMode() {
        return this.defaultAutoescapeMode;
    }

    public void setFilePath(String string) {
        int n = string.lastIndexOf(33);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        this.filePath = string;
        int n2 = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)string);
        this.fileName = n2 != -1 && n2 != string.length() - 1 ? string.substring(n2 + 1) : string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.namespace != null) {
            stringBuilder.append("{namespace ").append(this.namespace).append("}\n");
        }
        for (TemplateNode templateNode : this.getChildren()) {
            stringBuilder.append("\n");
            stringBuilder.append(templateNode.toSourceString());
        }
        return stringBuilder.toString();
    }

    @Override
    public SoyFileNode clone() {
        return new SoyFileNode(this);
    }
}

