/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialContentNode {
    public static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprUnion exprUnion;
    @Nullable
    private final String userSuppliedPlaceholderName;

    public PrintNode(int n, boolean bl, String string, @Nullable String string2) throws SoySyntaxException {
        super(n, "print", "");
        ExprRootNode<?> exprRootNode;
        this.isImplicit = bl;
        try {
            exprRootNode = new ExpressionParser(string).parseExpression();
        }
        catch (TokenMgrError tokenMgrError) {
            exprRootNode = null;
        }
        catch (ParseException parseException) {
            exprRootNode = null;
        }
        if (exprRootNode != null) {
            this.exprUnion = new ExprUnion(exprRootNode);
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.exprUnion = new ExprUnion(string);
        }
        this.userSuppliedPlaceholderName = string2;
    }

    public PrintNode(int n, boolean bl, ExprUnion exprUnion, @Nullable String string) {
        super(n, "print", "");
        this.isImplicit = bl;
        this.exprUnion = exprUnion;
        this.userSuppliedPlaceholderName = string;
    }

    protected PrintNode(PrintNode printNode) {
        super(printNode);
        this.isImplicit = printNode.isImplicit;
        this.exprUnion = printNode.exprUnion != null ? printNode.exprUnion.clone() : null;
        this.userSuppliedPlaceholderName = printNode.userSuppliedPlaceholderName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public String getExprText() {
        return this.exprUnion.getExprText();
    }

    public ExprUnion getExprUnion() {
        return this.exprUnion;
    }

    @Override
    public String getUserSuppliedPlaceholderName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePlaceholderName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        ExprRootNode<?> exprRootNode = this.exprUnion.getExpr();
        if (exprRootNode == null) {
            return FALLBACK_BASE_PLACEHOLDER_NAME;
        }
        Node node = exprRootNode.getChild(0);
        if (node instanceof DataRefNode) {
            DataRefNode dataRefNode = (DataRefNode)node;
            ExprNode exprNode = dataRefNode.getChild(dataRefNode.numChildren() - 1);
            if (exprNode instanceof DataRefKeyNode) {
                return BaseUtils.convertToUpperUnderscore(((DataRefKeyNode)exprNode).getKey());
            }
        } else if (node instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)node;
            int n = globalNode.getName().lastIndexOf(46);
            String string = globalNode.getName().substring(n + 1);
            return BaseUtils.convertToUpperUnderscore(string);
        }
        return FALLBACK_BASE_PLACEHOLDER_NAME;
    }

    @Override
    public Object genSamenessKey() {
        return this.getCommandText();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.exprUnion);
    }

    @Override
    public String getCommandText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.exprUnion.getExprText());
        for (PrintDirectiveNode printDirectiveNode : this.getChildren()) {
            stringBuilder.append(' ').append(printDirectiveNode.toSourceString());
        }
        if (this.userSuppliedPlaceholderName != null) {
            stringBuilder.append(" phname=\"").append(this.userSuppliedPlaceholderName).append('\"');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(false, this.isImplicit);
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public PrintNode clone() {
        return new PrintNode(this);
    }
}

