/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public class MsgSelectCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private final String caseValue;

    public MsgSelectCaseNode(int n, String string) throws SoySyntaxException {
        super(n, "case", string);
        try {
            ExprRootNode<?> exprRootNode = new ExpressionParser(string).parseExpression();
            if (exprRootNode.numChildren() != 1 || !(exprRootNode.getChild(0) instanceof StringNode)) {
                throw new SoySyntaxException("Invalid string for select 'case'.");
            }
            this.caseValue = ((StringNode)exprRootNode.getChild(0)).getValue();
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidExprList(tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidExprList(parseException);
        }
    }

    protected MsgSelectCaseNode(MsgSelectCaseNode msgSelectCaseNode) {
        super(msgSelectCaseNode);
        this.caseValue = msgSelectCaseNode.caseValue;
    }

    private SoySyntaxException createExceptionForInvalidExprList(Throwable throwable) {
        return new SoySyntaxException("Invalid expression in 'case' command text \"" + this.getCommandText() + "\".", throwable);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_CASE_NODE;
    }

    public String getCaseValue() {
        return this.caseValue;
    }

    @Override
    public MsgSelectCaseNode clone() {
        return new MsgSelectCaseNode(this);
    }
}

