/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgPluralNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("(.+?) ( \\s+ offset= .+ )?", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("plural", new CommandTextAttributesParser.Attribute("offset", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final int offset;
    private final ExprRootNode<?> pluralExpr;

    public MsgPluralNode(int n, String string) throws SoySyntaxException {
        block8: {
            super(n, "plural", string);
            Matcher matcher = COMMAND_TEXT_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new SoySyntaxException("Invalid 'plural' command text \"" + string + "\".");
            }
            try {
                this.pluralExpr = new ExpressionParser(matcher.group(1)).parseExpression();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.createExceptionForInvalidCommandText("expression", tokenMgrError);
            }
            catch (ParseException parseException) {
                throw this.createExceptionForInvalidCommandText("expression", parseException);
            }
            if (matcher.group(2) != null) {
                try {
                    Map<String, String> map = ATTRIBUTES_PARSER.parse(matcher.group(2).trim());
                    String string2 = map.get("offset");
                    this.offset = Integer.parseInt(string2);
                    if (this.offset < 0) {
                        throw new SoySyntaxException("The 'offset' for plural must be a nonnegative integer.");
                    }
                    break block8;
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.createExceptionForInvalidCommandText("offset", numberFormatException);
                }
            }
            this.offset = 0;
        }
    }

    protected MsgPluralNode(MsgPluralNode msgPluralNode) {
        super(msgPluralNode);
        this.offset = msgPluralNode.offset;
        this.pluralExpr = msgPluralNode.pluralExpr.clone();
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String string, Throwable throwable) {
        return new SoySyntaxException("Invalid " + string + " in 'plural' command text \"" + this.getCommandText() + "\".", throwable);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_NODE;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getExprText() {
        return this.pluralExpr.toSourceString();
    }

    public ExprRootNode<?> getExpr() {
        return this.pluralExpr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.pluralExpr));
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgPluralNode clone() {
        return new MsgPluralNode(this);
    }
}

