/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MsgHtmlTagNode
extends AbstractBlockNode
implements SoyNode.MsgPlaceholderInitialContentNode {
    private static final Pattern PHNAME_ATTR_PATTERN = Pattern.compile("\\s phname=\" ( [^\"]* ) \"", 4);
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("(?<= ^< ) /? [a-zA-Z0-9]+", 4);
    private static final Map<String, String> LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP = ImmutableMap.builder().put((Object)"a", (Object)"link").put((Object)"br", (Object)"break").put((Object)"b", (Object)"bold").put((Object)"i", (Object)"italic").put((Object)"li", (Object)"item").put((Object)"ol", (Object)"ordered_list").put((Object)"ul", (Object)"unordered_list").put((Object)"p", (Object)"paragraph").put((Object)"img", (Object)"image").put((Object)"em", (Object)"emphasis").build();
    private final String lcTagName;
    private final boolean isSelfEnding;
    private final boolean isOnlyRawText;
    @Nullable
    private final String fullTagText;
    @Nullable
    private final String userSuppliedPlaceholderName;

    public MsgHtmlTagNode(int n, List<SoyNode.StandaloneNode> list) throws SoySyntaxException {
        super(n);
        CharSequence charSequence;
        Object object;
        int n2 = list.size();
        String string = null;
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            object = list.get(i);
            if (!(object instanceof RawTextNode)) continue;
            do {
                Object object2;
                if (((Matcher)(object2 = PHNAME_ATTR_PATTERN.matcher(charSequence = ((RawTextNode)object).getRawText()))).find()) {
                    if (string != null) {
                        throw new SoySyntaxException("Found multiple 'phname' attributes in HTML tag (phname=\"" + string + "\" and phname=\"" + ((Matcher)object2).group(1) + "\").");
                    }
                    string = ((Matcher)object2).group(1);
                    if (!BaseUtils.isIdentifier(string)) {
                        throw new SoySyntaxException("Found 'phname' attribute in HTML tag that is not a valid identifier (phname=\"" + string + "\").");
                    }
                    SoyNode.StandaloneNode standaloneNode = new RawTextNode(object.getId(), ((String)charSequence).replaceFirst(((Matcher)object2).group(), ""));
                    list.set(i, standaloneNode);
                    object = standaloneNode;
                    bl = true;
                    continue;
                }
                bl = false;
            } while (bl);
        }
        this.userSuppliedPlaceholderName = string;
        String string2 = ((RawTextNode)list.get(0)).getRawText();
        object = TAG_NAME_PATTERN.matcher(string2);
        if (!((Matcher)object).find()) {
            if (string2.startsWith("<!--")) {
                throw new SoySyntaxException("Found HTML comment within 'msg' block: " + string2);
            }
            throw new SoySyntaxException("HTML tag within 'msg' block has no tag name: " + string2);
        }
        this.lcTagName = ((Matcher)object).group().toLowerCase(Locale.ENGLISH);
        String string3 = ((RawTextNode)list.get(n2 - 1)).getRawText();
        this.isSelfEnding = string3.endsWith("/>");
        boolean bl = this.isOnlyRawText = n2 == 1;
        if (this.isOnlyRawText) {
            charSequence = new StringBuilder();
            for (SoyNode.StandaloneNode standaloneNode : list) {
                ((StringBuilder)charSequence).append(standaloneNode.toSourceString());
            }
            this.fullTagText = ((StringBuilder)charSequence).toString();
        } else {
            this.fullTagText = null;
        }
        this.addChildren(list);
    }

    protected MsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        super(msgHtmlTagNode);
        this.lcTagName = msgHtmlTagNode.lcTagName;
        this.isSelfEnding = msgHtmlTagNode.isSelfEnding;
        this.isOnlyRawText = msgHtmlTagNode.isOnlyRawText;
        this.fullTagText = msgHtmlTagNode.fullTagText;
        this.userSuppliedPlaceholderName = msgHtmlTagNode.userSuppliedPlaceholderName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_HTML_TAG_NODE;
    }

    public String getLcTagName() {
        return this.lcTagName;
    }

    @Nullable
    public String getFullTagText() {
        return this.fullTagText;
    }

    @Override
    public String getUserSuppliedPlaceholderName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePlaceholderName() {
        String string;
        String string2;
        boolean bl;
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        if (this.lcTagName.startsWith("/")) {
            bl = true;
            string2 = this.lcTagName.substring(1);
        } else {
            bl = false;
            string2 = this.lcTagName;
        }
        String string3 = string = LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.containsKey(string2) ? LC_TAG_NAME_TO_PLACEHOLDER_NAME_MAP.get(string2) : string2;
        if (bl) {
            string = "end_" + string;
        } else if (!this.isSelfEnding) {
            string = "start_" + string;
        }
        return string.toUpperCase();
    }

    @Override
    public Object genSamenessKey() {
        return this.isOnlyRawText ? Pair.of(this.userSuppliedPlaceholderName, this.fullTagText) : Integer.valueOf(this.getId());
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendSourceStringForChildren(stringBuilder);
        if (this.userSuppliedPlaceholderName != null) {
            int n;
            if (this.isSelfEnding ? !stringBuilder.substring(n = stringBuilder.length() - 2).equals("/>") : !stringBuilder.substring(n = stringBuilder.length() - 1).equals(">")) {
                throw new AssertionError();
            }
            stringBuilder.insert(n, " phname=\"" + this.userSuppliedPlaceholderName + "\"");
        }
        return stringBuilder.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgHtmlTagNode clone() {
        return new MsgHtmlTagNode(this);
    }
}

