/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class LetValueNode
extends LetNode
implements SoyNode.ExprHolderNode {
    private final String varName;
    private final ExprRootNode<?> valueExpr;

    public LetValueNode(int n, boolean bl, String string) {
        super(n, bl, string);
        Pair<String, ExprRootNode<?>> pair = this.parseCommandTextHelper(string);
        this.varName = (String)pair.first;
        this.valueExpr = (ExprRootNode)pair.second;
        if (this.valueExpr == null) {
            throw new SoySyntaxException("A 'let' tag should be self-ending (with a trailing '/') if and only if it also contains a value (invalid tag is {let " + string + " /}).");
        }
    }

    protected LetValueNode(LetValueNode letValueNode) {
        super(letValueNode);
        this.varName = letValueNode.varName;
        this.valueExpr = letValueNode.valueExpr.clone();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.LET_VALUE_NODE;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    public ExprRootNode<?> getValueExpr() {
        return this.valueExpr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.valueExpr));
    }

    @Override
    public SoyNode clone() {
        return new LetValueNode(this);
    }
}

