/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.Lists;
import com.google.template.soy.exprtree.ExprRootNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ExprUnion {
    @Nullable
    private final ExprRootNode<?> expr;
    @Nullable
    private final String exprText;

    public static List<ExprUnion> createList(List<? extends ExprRootNode<?>> list) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (ExprRootNode<?> exprRootNode : list) {
            arrayList.add(new ExprUnion(exprRootNode));
        }
        return arrayList;
    }

    public ExprUnion(ExprRootNode<?> exprRootNode) {
        this.expr = exprRootNode;
        this.exprText = null;
    }

    public ExprUnion(String string) {
        this.expr = null;
        this.exprText = string;
    }

    public ExprRootNode<?> getExpr() {
        return this.expr;
    }

    public String getExprText() {
        return this.expr != null ? this.expr.toSourceString() : this.exprText;
    }

    public ExprUnion clone() {
        return this.expr != null ? new ExprUnion((ExprRootNode<?>)this.expr.clone()) : new ExprUnion(this.exprText);
    }
}

