/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class CssNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    @Nullable
    private final ExprRootNode<?> componentNameExpr;
    private final String selectorText;

    public CssNode(int n, String string) throws SoySyntaxException {
        super(n, "css", string);
        int n2 = string.lastIndexOf(44);
        if (n2 != -1) {
            String string2 = string.substring(0, n2).trim();
            try {
                this.componentNameExpr = new ExpressionParser(string2).parseExpression();
            }
            catch (TokenMgrError tokenMgrError) {
                throw new SoySyntaxException("Token error processing " + string2 + " in CSS node.");
            }
            catch (ParseException parseException) {
                throw new SoySyntaxException("Parse exception processing " + string2 + " in CSS node");
            }
            this.selectorText = string.substring(n2 + 1).trim();
        } else {
            this.componentNameExpr = null;
            this.selectorText = string;
        }
    }

    protected CssNode(CssNode cssNode) {
        super(cssNode);
        this.componentNameExpr = cssNode.componentNameExpr != null ? cssNode.componentNameExpr.clone() : null;
        this.selectorText = cssNode.selectorText;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CSS_NODE;
    }

    public ExprRootNode<?> getComponentNameExpr() {
        return this.componentNameExpr;
    }

    public String getComponentNameText() {
        return this.componentNameExpr != null ? this.componentNameExpr.toSourceString() : null;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return this.componentNameExpr != null ? ImmutableList.of((Object)new ExprUnion(this.componentNameExpr)) : Collections.emptyList();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public CssNode clone() {
        return new CssNode(this);
    }
}

