/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class CallParamNode
extends AbstractCommandNode {
    private static final Pattern NONATTRIBUTE_COMMAND_TEXT = Pattern.compile("^ (?! key=\") (\\w+) (?: \\s* : \\s* (\\S .*) )? $", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("param", new CommandTextAttributesParser.Attribute("key", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("value", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));

    protected CallParamNode(int n, String string) {
        super(n, "param", string);
    }

    protected CallParamNode(CallParamNode callParamNode) {
        super(callParamNode);
    }

    protected CommandTextParseResult parseCommandTextHelper(String string) throws SoySyntaxException {
        ExprUnion exprUnion;
        ExprRootNode<?> exprRootNode;
        String string2;
        String string3;
        Matcher matcher = NONATTRIBUTE_COMMAND_TEXT.matcher(string);
        if (matcher.matches()) {
            string3 = matcher.group(1);
            string2 = matcher.group(2);
        } else {
            exprRootNode = ATTRIBUTES_PARSER.parse(string);
            string3 = exprRootNode.get("key");
            string2 = exprRootNode.get("value");
        }
        try {
            exprRootNode = (DataRefNode)new ExpressionParser("$" + string3).parseDataReference().getChild(0);
            if (exprRootNode.numChildren() > 1 || ((DataRefNode)((Object)exprRootNode)).isIjDataRef()) {
                throw new SoySyntaxException("The key in a 'param' tag must be top level, i.e. not contain multiple keys (invalid 'param' command text \"" + this.getCommandText() + "\").");
            }
        }
        catch (TokenMgrError tokenMgrError) {
            throw this.createExceptionForInvalidKey(tokenMgrError);
        }
        catch (ParseException parseException) {
            throw this.createExceptionForInvalidKey(parseException);
        }
        if (string2 != null) {
            try {
                exprRootNode = new ExpressionParser(string2).parseExpression();
            }
            catch (TokenMgrError tokenMgrError) {
                exprRootNode = null;
            }
            catch (ParseException parseException) {
                exprRootNode = null;
            }
            exprUnion = exprRootNode != null ? new ExprUnion(exprRootNode) : new ExprUnion(string2);
        } else {
            exprUnion = null;
        }
        return new CommandTextParseResult(string3, exprUnion);
    }

    private SoySyntaxException createExceptionForInvalidKey(Throwable throwable) {
        return new SoySyntaxException("Invalid key in 'param' command text \"" + this.getCommandText() + "\".", throwable);
    }

    public abstract String getKey();

    @Override
    public CallNode getParent() {
        return (CallNode)super.getParent();
    }

    protected static class CommandTextParseResult {
        public final String key;
        @Nullable
        public final ExprUnion valueExprUnion;

        private CommandTextParseResult(String string, ExprUnion exprUnion) {
            this.key = string;
            this.valueExprUnion = exprUnion;
        }
    }
}

