/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class CallDelegateNode
extends CallNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final String delCalleeName;

    public CallDelegateNode(int n, String string, @Nullable String string2) throws SoySyntaxException {
        this(n, CallDelegateNode.parseCommandTextHelper(string, string2));
    }

    private static final CommandTextInfo parseCommandTextHelper(String string, @Nullable String string2) {
        Map<String, String> map;
        String string3;
        String string4 = string + (string2 != null ? " phname=\"" + string2 + "\"" : "");
        Matcher matcher = NONATTRIBUTE_CALLEE_NAME.matcher(string);
        if (matcher.find()) {
            string = matcher.replaceFirst("name=\"" + matcher.group() + "\"");
        }
        if ((string3 = (map = ATTRIBUTES_PARSER.parse(string)).get("name")) == null) {
            throw new SoySyntaxException("The 'delcall' command text must contain the callee name.");
        }
        if (!BaseUtils.isDottedIdentifier(string3)) {
            throw new SoySyntaxException("Invalid delegate name \"" + string3 + "\" for 'delcall' command.");
        }
        Pair<Boolean, String> pair = CallDelegateNode.parseDataAttributeHelper(map.get("data"));
        return new CommandTextInfo(string4, string3, (Boolean)pair.first, (String)pair.second, string2);
    }

    public CallDelegateNode(int n, String string, boolean bl, boolean bl2, boolean bl3, @Nullable String string2, @Nullable String string3) {
        this(n, CallDelegateNode.buildCommandTextInfoHelper(string, bl, bl2, bl3, string2, string3));
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String string, boolean bl, boolean bl2, boolean bl3, @Nullable String string2, @Nullable String string3) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string));
        if (bl3) {
            Preconditions.checkArgument((boolean)bl2);
        }
        if (string2 != null) {
            Preconditions.checkArgument((bl2 && !bl3 ? 1 : 0) != 0);
            Preconditions.checkArgument((!string2.contains("\"") ? 1 : 0) != 0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("name=\"").append(string).append('\"');
        } else {
            stringBuilder.append(string);
        }
        if (bl3) {
            stringBuilder.append(" data=\"all\"");
        } else if (bl2) {
            stringBuilder.append(" data=\"").append(string2).append('\"');
        }
        if (string3 != null) {
            stringBuilder.append(" phname=\"").append(string3).append('\"');
        }
        return new CommandTextInfo(stringBuilder.toString(), string, bl2, string2, string3);
    }

    private CallDelegateNode(int n, CommandTextInfo commandTextInfo) {
        super(n, "delcall", commandTextInfo);
        this.delCalleeName = commandTextInfo.delCalleeName;
    }

    protected CallDelegateNode(CallDelegateNode callDelegateNode) {
        super(callDelegateNode);
        this.delCalleeName = callDelegateNode.delCalleeName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    @Override
    public CallDelegateNode clone() {
        return new CallDelegateNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        public final String delCalleeName;

        public CommandTextInfo(String string, String string2, boolean bl, @Nullable String string3, @Nullable String string4) {
            super(string, bl, string3, string4, SoyNode.SyntaxVersion.V2);
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string2));
            this.delCalleeName = string2;
        }
    }
}

