/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class CallBasicNode
extends CallNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\" | function=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("function", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    @Nullable
    private String calleeName;
    @Nullable
    private final String partialCalleeName;

    public CallBasicNode(int n, String string, @Nullable String string2) throws SoySyntaxException {
        this(n, CallBasicNode.parseCommandTextHelper(string, string2));
    }

    private static final CommandTextInfo parseCommandTextHelper(String string, @Nullable String string2) {
        String string3;
        String string4;
        String string5;
        Map<String, String> map;
        String string6;
        String string7 = string + (string2 != null ? " phname=\"" + string2 + "\"" : "");
        SoyNode.SyntaxVersion syntaxVersion = SoyNode.SyntaxVersion.V2;
        Matcher matcher = NONATTRIBUTE_CALLEE_NAME.matcher(string);
        if (matcher.find()) {
            string = matcher.replaceFirst("name=\"" + matcher.group() + "\"");
        }
        if ((string6 = (map = ATTRIBUTES_PARSER.parse(string)).get("name")) == null == ((string5 = map.get("function")) == null)) {
            throw new SoySyntaxException("The 'call' command text must contain the callee name.");
        }
        if (string5 != null) {
            string6 = string5;
            syntaxVersion = SoyNode.SyntaxVersion.V1;
        }
        if (BaseUtils.isIdentifierWithLeadingDot(string6)) {
            string4 = string6;
            string3 = null;
        } else if (BaseUtils.isDottedIdentifier(string6)) {
            string3 = string6;
            string4 = null;
        } else {
            throw new SoySyntaxException("Invalid callee name \"" + string6 + "\" for 'call' command.");
        }
        Pair<Boolean, String> pair = CallBasicNode.parseDataAttributeHelper(map.get("data"));
        return new CommandTextInfo(string7, string3, string4, (Boolean)pair.first, (String)pair.second, string2, syntaxVersion);
    }

    public CallBasicNode(int n, String string, @Nullable String string2, boolean bl, boolean bl2, boolean bl3, @Nullable String string3, @Nullable String string4, SoyNode.SyntaxVersion syntaxVersion) {
        this(n, CallBasicNode.buildCommandTextInfoHelper(string, string2, bl, bl2, bl3, string3, string4, syntaxVersion));
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String string, @Nullable String string2, boolean bl, boolean bl2, boolean bl3, @Nullable String string3, @Nullable String string4, SoyNode.SyntaxVersion syntaxVersion) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string));
        Preconditions.checkArgument((string2 == null || BaseUtils.isIdentifierWithLeadingDot(string2) ? 1 : 0) != 0);
        if (bl3) {
            Preconditions.checkArgument((boolean)bl2);
        }
        if (string3 != null) {
            Preconditions.checkArgument((bl2 && !bl3 ? 1 : 0) != 0);
            Preconditions.checkArgument((!string3.contains("\"") ? 1 : 0) != 0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (syntaxVersion == SoyNode.SyntaxVersion.V1) {
            stringBuilder.append("function=\"").append(string).append('\"');
        } else {
            String string5;
            String string6 = string5 = string2 != null ? string2 : string;
            if (bl) {
                stringBuilder.append("name=\"").append(string5).append('\"');
            } else {
                stringBuilder.append(string5);
            }
        }
        if (bl3) {
            stringBuilder.append(" data=\"all\"");
        } else if (bl2) {
            stringBuilder.append(" data=\"").append(string3).append('\"');
        }
        if (string4 != null) {
            stringBuilder.append(" phname=\"").append(string4).append('\"');
        }
        return new CommandTextInfo(stringBuilder.toString(), string, string2, bl2, string3, string4, syntaxVersion);
    }

    private CallBasicNode(int n, CommandTextInfo commandTextInfo) {
        super(n, "call", commandTextInfo);
        this.calleeName = commandTextInfo.calleeName;
        this.partialCalleeName = commandTextInfo.partialCalleeName;
    }

    protected CallBasicNode(CallBasicNode callBasicNode) {
        super(callBasicNode);
        this.calleeName = callBasicNode.calleeName;
        this.partialCalleeName = callBasicNode.partialCalleeName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public void setCalleeName(String string) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(string));
        this.calleeName = string;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    public String getPartialCalleeName() {
        return this.partialCalleeName;
    }

    @Override
    public CallBasicNode clone() {
        return new CallBasicNode(this);
    }

    @Immutable
    protected static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        @Nullable
        private final String calleeName;
        @Nullable
        private final String partialCalleeName;

        public CommandTextInfo(String string, @Nullable String string2, @Nullable String string3, boolean bl, @Nullable String string4, @Nullable String string5, SoyNode.SyntaxVersion syntaxVersion) {
            super(string, bl, string4, string5, syntaxVersion);
            Preconditions.checkArgument((string2 == null || BaseUtils.isDottedIdentifier(string2) ? 1 : 0) != 0);
            Preconditions.checkArgument((string3 == null || BaseUtils.isIdentifierWithLeadingDot(string3) ? 1 : 0) != 0);
            Preconditions.checkArgument((string2 != null || string3 != null ? 1 : 0) != 0);
            this.calleeName = string2;
            this.partialCalleeName = string3;
        }
    }
}

