/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum AutoescapeMode {
    FALSE,
    TRUE,
    CONTEXTUAL;

    private final String attributeValue = this.name().toLowerCase(Locale.ENGLISH);

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (AutoescapeMode autoescapeMode : AutoescapeMode.values()) {
            builder.add((Object)autoescapeMode.getAttributeValue());
        }
        return builder.build();
    }

    static Set<String> getAttributeValuesAndNull() {
        HashSet hashSet = Sets.newHashSet(AutoescapeMode.getAttributeValues());
        hashSet.add(null);
        return hashSet;
    }

    public static AutoescapeMode forAttributeValue(String string) {
        return AutoescapeMode.valueOf(string.toUpperCase(Locale.ENGLISH));
    }
}

