/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMsgNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.MsgBlockNode {
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("msg", new CommandTextAttributesParser.Attribute("meaning", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("desc", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("hidden", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"));
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    private Map<String, MsgPlaceholderNode> phNameToRepNodeMap = null;
    private Map<MsgPlaceholderNode, String> phNodeToNameMap = null;
    private Map<String, MsgPluralNode> pluralVarNameToRepNodeMap = null;
    private Map<MsgPluralNode, String> pluralNodeToVarNameMap = null;
    private Map<String, MsgSelectNode> selectVarNameToRepNodeMap = null;
    private Map<MsgSelectNode, String> selectNodeToVarNameMap = null;

    public AbstractMsgNode(int n, String string) throws SoySyntaxException {
        super(n, "msg", string);
        Map<String, String> map = ATTRIBUTES_PARSER.parse(string);
        this.meaning = map.get("meaning");
        this.desc = map.get("desc");
        this.isHidden = map.get("hidden").equals("true");
    }

    protected AbstractMsgNode(int n, AbstractMsgNode abstractMsgNode) {
        super(n, "msg", abstractMsgNode.getCommandText());
        this.meaning = abstractMsgNode.meaning;
        this.desc = abstractMsgNode.desc;
        this.isHidden = abstractMsgNode.isHidden;
        this.phNameToRepNodeMap = abstractMsgNode.phNameToRepNodeMap != null ? ImmutableMap.copyOf(abstractMsgNode.phNameToRepNodeMap) : null;
        this.phNodeToNameMap = abstractMsgNode.phNodeToNameMap != null ? ImmutableMap.copyOf(abstractMsgNode.phNodeToNameMap) : null;
        this.pluralVarNameToRepNodeMap = abstractMsgNode.pluralVarNameToRepNodeMap != null ? ImmutableMap.copyOf(abstractMsgNode.pluralVarNameToRepNodeMap) : null;
        this.pluralNodeToVarNameMap = abstractMsgNode.pluralNodeToVarNameMap != null ? ImmutableMap.copyOf(abstractMsgNode.pluralNodeToVarNameMap) : null;
        this.selectVarNameToRepNodeMap = abstractMsgNode.selectVarNameToRepNodeMap != null ? ImmutableMap.copyOf(abstractMsgNode.selectVarNameToRepNodeMap) : null;
        this.selectNodeToVarNameMap = abstractMsgNode.selectNodeToVarNameMap != null ? ImmutableMap.copyOf(abstractMsgNode.selectNodeToVarNameMap) : null;
    }

    protected AbstractMsgNode(AbstractMsgNode abstractMsgNode) {
        super(abstractMsgNode);
        this.meaning = abstractMsgNode.meaning;
        this.desc = abstractMsgNode.desc;
        this.isHidden = abstractMsgNode.isHidden;
        this.genPhNamesAndSelectPluralVarsHelper();
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public MsgPlaceholderNode getRepPlaceholderNode(String string) {
        if (this.phNameToRepNodeMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.phNameToRepNodeMap.get(string);
    }

    public String getPlaceholderName(MsgPlaceholderNode msgPlaceholderNode) {
        if (this.phNodeToNameMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.phNodeToNameMap.get(msgPlaceholderNode);
    }

    public MsgPluralNode getRepPluralNode(String string) {
        if (this.pluralVarNameToRepNodeMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.pluralVarNameToRepNodeMap.get(string);
    }

    public String getPluralVarName(MsgPluralNode msgPluralNode) {
        if (this.pluralNodeToVarNameMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.pluralNodeToVarNameMap.get(msgPluralNode);
    }

    public MsgSelectNode getRepSelectNode(String string) {
        if (this.selectVarNameToRepNodeMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.selectVarNameToRepNodeMap.get(string);
    }

    public String getSelectVarName(MsgSelectNode msgSelectNode) {
        if (this.selectNodeToVarNameMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.selectNodeToVarNameMap.get(msgSelectNode);
    }

    /*
     * WARNING - void declaration
     */
    protected void genPhNamesAndSelectPluralVarsHelper() {
        Object object;
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        ArrayDeque<SoyNode> arrayDeque = new ArrayDeque<SoyNode>();
        for (SoyNode.StandaloneNode object2 : this.getChildren()) {
            if (!(object2 instanceof MsgPlaceholderNode) && !(object2 instanceof MsgPluralNode) && !(object2 instanceof MsgSelectNode)) continue;
            arrayDeque.add(object2);
        }
        while (arrayDeque.size() > 0) {
            void var5_10;
            SoyNode soyNode = (SoyNode)arrayDeque.remove();
            if (soyNode instanceof MsgSelectNode) {
                AbstractMsgNode.addGrandchildrenToQueue(arrayDeque, (MsgSelectNode)soyNode);
                String string = AbstractMsgNode.getBaseVarNameFromExpr(((MsgSelectNode)soyNode).getExpr(), "STATUS");
            } else if (soyNode instanceof MsgPluralNode) {
                AbstractMsgNode.addGrandchildrenToQueue(arrayDeque, (MsgPluralNode)soyNode);
                String string = AbstractMsgNode.getBaseVarNameFromExpr(((MsgPluralNode)soyNode).getExpr(), "NUM");
            } else if (soyNode instanceof MsgPlaceholderNode) {
                String string = ((MsgPlaceholderNode)soyNode).genBasePlaceholderName();
            } else {
                throw new AssertionError();
            }
            if (!hashMap.containsKey(var5_10)) {
                hashMap.put(var5_10, Lists.newArrayList((Object[])new SoyNode[]{soyNode}));
                continue;
            }
            object = (List)hashMap.get(var5_10);
            boolean bl = true;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SoyNode soyNode2 = (SoyNode)iterator.next();
                if (!AbstractMsgNode.isSameAs(soyNode, soyNode2)) continue;
                hashMap2.put(soyNode, soyNode2);
                bl = false;
                break;
            }
            if (!bl) continue;
            object.add(soyNode);
        }
        this.phNameToRepNodeMap = Maps.newHashMap();
        this.pluralVarNameToRepNodeMap = Maps.newHashMap();
        this.selectVarNameToRepNodeMap = Maps.newHashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            List list = (List)entry.getValue();
            if (list.size() == 1) {
                this.updateFinalMapsWithNode((String)object, (SoyNode)list.get(0));
                continue;
            }
            int n = 1;
            for (SoyNode soyNode : list) {
                String string;
                do {
                    string = (String)object + "_" + n;
                    ++n;
                } while (hashMap.containsKey(string));
                this.updateFinalMapsWithNode(string, soyNode);
            }
        }
        this.phNodeToNameMap = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.phNameToRepNodeMap.entrySet()) {
            this.phNodeToNameMap.put((MsgPlaceholderNode)entry.getValue(), (String)entry.getKey());
        }
        this.selectNodeToVarNameMap = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.selectVarNameToRepNodeMap.entrySet()) {
            this.selectNodeToVarNameMap.put((MsgSelectNode)entry.getValue(), (String)entry.getKey());
        }
        this.pluralNodeToVarNameMap = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.pluralVarNameToRepNodeMap.entrySet()) {
            this.pluralNodeToVarNameMap.put((MsgPluralNode)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : hashMap2.entrySet()) {
            object = (SoyNode)entry.getKey();
            SoyNode soyNode = (SoyNode)entry.getValue();
            if (object instanceof MsgPlaceholderNode) {
                this.phNodeToNameMap.put((MsgPlaceholderNode)object, this.phNodeToNameMap.get(soyNode));
                continue;
            }
            if (object instanceof MsgSelectNode) {
                this.selectNodeToVarNameMap.put((MsgSelectNode)object, this.selectNodeToVarNameMap.get(soyNode));
                continue;
            }
            if (!(object instanceof MsgPluralNode)) continue;
            this.pluralNodeToVarNameMap.put((MsgPluralNode)object, this.pluralNodeToVarNameMap.get(soyNode));
        }
    }

    private static void addGrandchildrenToQueue(Deque<SoyNode> deque, SoyNode.ParentSoyNode<CaseOrDefaultNode> parentSoyNode) {
        for (CaseOrDefaultNode caseOrDefaultNode : parentSoyNode.getChildren()) {
            for (SoyNode.StandaloneNode standaloneNode : caseOrDefaultNode.getChildren()) {
                if (!(standaloneNode instanceof MsgPlaceholderNode) && !(standaloneNode instanceof MsgPluralNode) && !(standaloneNode instanceof MsgSelectNode)) continue;
                deque.add(standaloneNode);
            }
        }
    }

    private void updateFinalMapsWithNode(String string, SoyNode soyNode) {
        if (soyNode instanceof MsgPlaceholderNode) {
            this.phNameToRepNodeMap.put(string, (MsgPlaceholderNode)soyNode);
        } else if (soyNode instanceof MsgSelectNode) {
            this.selectVarNameToRepNodeMap.put(string, (MsgSelectNode)soyNode);
        } else if (soyNode instanceof MsgPluralNode) {
            this.pluralVarNameToRepNodeMap.put(string, (MsgPluralNode)soyNode);
        }
    }

    private static boolean isSameAs(SoyNode soyNode, SoyNode soyNode2) {
        if (soyNode instanceof MsgPlaceholderNode && soyNode2 instanceof MsgPlaceholderNode) {
            return ((MsgPlaceholderNode)soyNode).isSamePlaceholderAs((MsgPlaceholderNode)soyNode2);
        }
        if (soyNode instanceof MsgPluralNode && soyNode2 instanceof MsgPluralNode) {
            return ((MsgPluralNode)soyNode).getCommandText().equals(((MsgPluralNode)soyNode2).getCommandText());
        }
        if (soyNode instanceof MsgSelectNode && soyNode2 instanceof MsgSelectNode) {
            return ((MsgSelectNode)soyNode).getCommandText().equals(((MsgSelectNode)soyNode2).getCommandText());
        }
        return false;
    }

    public static String getBaseVarNameFromExpr(ExprRootNode<?> exprRootNode, String string) {
        Node node = exprRootNode.getChild(0);
        if (node instanceof DataRefNode) {
            DataRefNode dataRefNode = (DataRefNode)node;
            ExprNode exprNode = dataRefNode.getChild(dataRefNode.numChildren() - 1);
            if (exprNode instanceof DataRefKeyNode) {
                return BaseUtils.convertToUpperUnderscore(((DataRefKeyNode)exprNode).getKey());
            }
        } else if (node instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)node;
            int n = globalNode.getName().lastIndexOf(46);
            String string2 = globalNode.getName().substring(n + 1);
            return BaseUtils.convertToUpperUnderscore(string2);
        }
        return string;
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }
}

