/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.IncrementingIdGenerator;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.TemplateParser;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final Pattern ERROR_MSG_LINE_NUM_PAT = Pattern.compile("(?<=line )\\d+(?=, column )");
    private IdGenerator nodeIdGen;
    private String sourcePath = SourceLocation.UNKNOWN.getSourcePath();
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[3];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public SoyFileParser(Reader reader, IdGenerator idGenerator, String string) {
        this(reader);
        this.nodeIdGen = idGenerator;
        this.sourcePath = string;
    }

    public SoyFileParser(String string, IdGenerator idGenerator, String string2) {
        this(new StringReader(string), idGenerator, string2);
    }

    public static void main(String[] stringArray) throws SoySyntaxException, TokenMgrError, ParseException {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(System.in, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
        new SoyFileParser(inputStreamReader, (IdGenerator)new IncrementingIdGenerator(), "stdin").SoyFile();
        System.out.println("Valid input.");
    }

    public SoyFileNode parseSoyFile() throws SoySyntaxException, TokenMgrError, ParseException {
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        return this.SoyFile();
    }

    @VisibleForTesting
    static String adjustLineNumInErrorMsg(String string, int n) {
        Matcher matcher = ERROR_MSG_LINE_NUM_PAT.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        int n2 = n + Integer.parseInt(matcher.group());
        return string.substring(0, matcher.start()) + n2 + string.substring(matcher.end());
    }

    private final SoyFileNode SoyFile() throws ParseException, SoySyntaxException {
        int n;
        int n2;
        String string = null;
        String string2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                Token token = this.jj_consume_token(1);
                n2 = "{delpackage".length();
                n = token.image.length() - 1;
                string = token.image.substring(n2, n);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                Token token = this.jj_consume_token(5);
                n2 = "{namespace".length();
                n = token.image.length() - 1;
                string2 = token.image.substring(n2, n);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        SoyFileNode soyFileNode = new SoyFileNode(this.nodeIdGen.genId(), string, string2);
        soyFileNode.setLocation(new SourceLocation(this.sourcePath, 0));
        soyFileNode.setFilePath(this.sourcePath);
        TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = new TemplateNode.SoyFileHeaderInfo(soyFileNode);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block9;
                }
            }
            TemplateNode templateNode = this.Template(soyFileHeaderInfo);
            soyFileNode.addChild(templateNode);
        }
        this.jj_consume_token(0);
        return soyFileNode;
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException, SoySyntaxException {
        List<SoyNode.StandaloneNode> list;
        String string;
        Object object;
        Token token = this.jj_consume_token(15);
        Token token2 = token.specialToken;
        if (token2 != null && token2.kind == 12) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(0, "*/");
            object = token2.specialToken;
            while (((Token)object).kind != 9) {
                arrayList.add(0, ((Token)object).image);
                object = ((Token)object).specialToken;
            }
            arrayList.add(0, "/**");
            string = Joiner.on((String)"").join((Iterable)arrayList);
        } else {
            string = null;
        }
        boolean bl = token.image.startsWith("{template");
        object = token.image.substring(bl ? 10 : 13, token.image.length() - 1).trim();
        TemplateNode templateNode = bl ? new TemplateBasicNode(this.nodeIdGen.genId(), soyFileHeaderInfo, (String)object, string) : new TemplateDelegateNode(this.nodeIdGen.genId(), soyFileHeaderInfo, (String)object, string);
        templateNode.setLocation(new SourceLocation(this.sourcePath, token.beginLine));
        Token token3 = this.jj_consume_token(17);
        try {
            list = new TemplateParser(token3.image, this.sourcePath, token3.beginLine, this.nodeIdGen).parseTemplateBody();
        }
        catch (TokenMgrError tokenMgrError) {
            String string2 = SoyFileParser.adjustLineNumInErrorMsg(tokenMgrError.getMessage(), token.beginLine);
            throw new SoySyntaxException(string2, tokenMgrError).setTemplateName(templateNode.getTemplateNameForUserMsgs());
        }
        catch (ParseException parseException) {
            String string3 = SoyFileParser.adjustLineNumInErrorMsg(parseException.getMessage(), token.beginLine);
            throw new SoySyntaxException(string3, parseException).setTemplateName(templateNode.getTemplateNameForUserMsgs());
        }
        catch (SoySyntaxException soySyntaxException) {
            throw soySyntaxException.setTemplateName(templateNode.getTemplateNameForUserMsgs());
        }
        templateNode.addChildren(list);
        return templateNode;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{2, 32, 32768};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0};
    }

    public SoyFileParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public SoyFileParser(InputStream inputStream, String string) {
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(Reader reader) {
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(SoyFileParserTokenManager soyFileParserTokenManager) {
        this.token_source = soyFileParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SoyFileParserTokenManager soyFileParserTokenManager) {
        this.token_source = soyFileParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 3; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[36];
        for (n2 = 0; n2 < 36; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 36; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SoyFileParser.jj_la1_0();
        SoyFileParser.jj_la1_1();
    }
}

