/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.sharedpasses.opti.PrerenderVisitorFactory;
import com.google.template.soy.sharedpasses.opti.SimplifyExprVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class SimplifyVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final int MAX_LEN_FOR_PRERENDERED_CALL = 300;
    private final SimplifyExprVisitor simplifyExprVisitor;
    private final PrerenderVisitorFactory prerenderVisitorFactory;
    private IdGenerator nodeIdGen;
    private TemplateRegistry templateRegistry;
    private Set<String> templatesThatFailedPrerender;

    @Inject
    public SimplifyVisitor(SimplifyExprVisitor simplifyExprVisitor, PrerenderVisitorFactory prerenderVisitorFactory) {
        this.simplifyExprVisitor = simplifyExprVisitor;
        this.prerenderVisitorFactory = prerenderVisitorFactory;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)(soyNode instanceof SoyFileSetNode));
        SoyFileSetNode soyFileSetNode = (SoyFileSetNode)soyNode;
        SoytreeUtils.execOnAllV2Exprs(soyFileSetNode, this.simplifyExprVisitor);
        this.nodeIdGen = soyFileSetNode.getNodeIdGenerator();
        this.templateRegistry = new TemplateRegistry(soyFileSetNode);
        this.templatesThatFailedPrerender = Sets.newHashSet();
        super.exec(soyFileSetNode);
        return null;
    }

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        if (printNode.getSyntaxVersion() != SoyNode.SyntaxVersion.V2) {
            return;
        }
        SoyNode.BlockNode blockNode = printNode.getParent();
        if (blockNode instanceof SoyNode.MsgBlockNode) {
            return;
        }
        if (!SimplifyVisitor.isConstant(printNode.getExprUnion().getExpr())) {
            return;
        }
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            for (ExprRootNode<?> exprRootNode : printDirectiveNode.getArgs()) {
                if (SimplifyVisitor.isConstant(exprRootNode)) continue;
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.prerenderVisitorFactory.create(stringBuilder, this.templateRegistry, null, null).exec(printNode);
        }
        catch (RenderException renderException) {
            return;
        }
        blockNode.replaceChild(printNode, new RawTextNode(this.nodeIdGen.genId(), stringBuilder.toString()));
    }

    @Override
    protected void visitIfNode(IfNode ifNode) {
        this.visitSoyNode(ifNode);
        for (SoyNode soyNode : Lists.newArrayList(ifNode.getChildren())) {
            IfCondNode ifCondNode;
            ExprRootNode<?> exprRootNode;
            if (!(soyNode instanceof IfCondNode) || !SimplifyVisitor.isConstant(exprRootNode = (ifCondNode = (IfCondNode)soyNode).getExprUnion().getExpr())) continue;
            if (SimplifyVisitor.getConstantOrNull(exprRootNode).toBoolean()) {
                int n = ifNode.getChildIndex(ifCondNode);
                for (int i = ifNode.numChildren() - 1; i > n; --i) {
                    ifNode.removeChild(i);
                }
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId());
                ifElseNode.addChildren(ifCondNode.getChildren());
                ifNode.replaceChild(n, ifElseNode);
                break;
            }
            ifNode.removeChild(ifCondNode);
        }
        if (ifNode.numChildren() == 0) {
            ifNode.getParent().removeChild(ifNode);
        }
        if (ifNode.numChildren() == 1 && ifNode.getChild(0) instanceof IfElseNode) {
            SimplifyVisitor.replaceNodeWithList(ifNode, ((IfElseNode)ifNode.getChild(0)).getChildren());
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode switchNode) {
        this.visitSoyNode(switchNode);
        SoyData soyData = SimplifyVisitor.getConstantOrNull(switchNode.getExpr());
        if (soyData == null) {
            return;
        }
        for (SoyNode soyNode : Lists.newArrayList(switchNode.getChildren())) {
            if (!(soyNode instanceof SwitchCaseNode)) continue;
            SwitchCaseNode switchCaseNode = (SwitchCaseNode)soyNode;
            boolean bl = false;
            boolean bl2 = true;
            for (ExprRootNode<?> exprRootNode : switchCaseNode.getExprList()) {
                SoyData soyData2 = SimplifyVisitor.getConstantOrNull(exprRootNode);
                if (soyData2 == null) {
                    bl2 = false;
                    continue;
                }
                if (!soyData2.equals(soyData)) continue;
                bl = true;
                bl2 = false;
                break;
            }
            if (bl) {
                int n = switchNode.getChildIndex(switchCaseNode);
                for (int i = switchNode.numChildren() - 1; i > n; --i) {
                    switchNode.removeChild(i);
                }
                SwitchDefaultNode switchDefaultNode = new SwitchDefaultNode(this.nodeIdGen.genId());
                switchDefaultNode.addChildren(switchCaseNode.getChildren());
                switchNode.replaceChild(n, switchDefaultNode);
                break;
            }
            if (!bl2) continue;
            switchNode.removeChild(switchCaseNode);
        }
        if (switchNode.numChildren() == 1 && switchNode.getChild(0) instanceof SwitchDefaultNode) {
            SimplifyVisitor.replaceNodeWithList(switchNode, ((SwitchDefaultNode)switchNode.getChild(0)).getChildren());
        }
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode callBasicNode) {
        Object object2;
        this.visitSoyNode(callBasicNode);
        if (this.templatesThatFailedPrerender.contains(callBasicNode.getCalleeName())) {
            return;
        }
        if (callBasicNode.getParent() instanceof SoyNode.MsgBlockNode) {
            return;
        }
        if (callBasicNode.isPassingData()) {
            return;
        }
        for (Object object2 : callBasicNode.getChildren()) {
            if (object2 instanceof CallParamValueNode && SimplifyVisitor.isConstant(((CallParamValueNode)object2).getValueExprUnion().getExpr())) continue;
            return;
        }
        SoyMapData soyMapData = new SoyMapData();
        for (CallParamNode callParamNode : callBasicNode.getChildren()) {
            SoyData soyData = SimplifyVisitor.getConstantOrNull(((CallParamValueNode)callParamNode).getValueExprUnion().getExpr());
            soyMapData.putSingle(callParamNode.getKey(), soyData);
        }
        object2 = new StringBuilder();
        try {
            this.prerenderVisitorFactory.create((StringBuilder)object2, this.templateRegistry, soyMapData, null).exec(callBasicNode);
        }
        catch (RenderException renderException) {
            this.templatesThatFailedPrerender.add(callBasicNode.getCalleeName());
            return;
        }
        if (((StringBuilder)object2).length() <= 300) {
            callBasicNode.getParent().replaceChild(callBasicNode, new RawTextNode(this.nodeIdGen.genId(), ((StringBuilder)object2).toString()));
        }
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode callParamContentNode) {
        this.visitSoyNode(callParamContentNode);
        if (callParamContentNode.numChildren() == 1 && callParamContentNode.getChild(0) instanceof RawTextNode) {
            String string = ((RawTextNode)callParamContentNode.getChild(0)).getRawText();
            String string2 = callParamContentNode.getKey() + ": " + BaseUtils.escapeToSoyString(string, false);
            CallParamValueNode callParamValueNode = new CallParamValueNode(this.nodeIdGen.genId(), string2);
            callParamContentNode.getParent().replaceChild(callParamContentNode, callParamValueNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)soyNode);
        }
        if (!(soyNode instanceof SoyNode.BlockNode)) {
            return;
        }
        SoyNode.BlockNode blockNode = (SoyNode.BlockNode)soyNode;
        boolean bl = false;
        for (int i = 0; i <= blockNode.numChildren() - 2; ++i) {
            if (!(blockNode.getChild(i) instanceof RawTextNode) || !(blockNode.getChild(i + 1) instanceof RawTextNode)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList(blockNode.getChildren());
        blockNode.clearChildren();
        ArrayList arrayList2 = Lists.newArrayList();
        for (SoyNode.StandaloneNode standaloneNode : arrayList) {
            if (standaloneNode instanceof RawTextNode) {
                arrayList2.add((RawTextNode)standaloneNode);
                continue;
            }
            this.addConsecutiveRawTextNodesAsOneNodeHelper(blockNode, arrayList2);
            arrayList2.clear();
            blockNode.addChild(standaloneNode);
        }
        this.addConsecutiveRawTextNodesAsOneNodeHelper(blockNode, arrayList2);
        arrayList2.clear();
    }

    private static boolean isConstant(ExprRootNode<?> exprRootNode) {
        return exprRootNode != null && exprRootNode.getChild(0) instanceof ExprNode.ConstantNode;
    }

    private static SoyData getConstantOrNull(ExprRootNode<?> exprRootNode) {
        if (exprRootNode == null) {
            return null;
        }
        Node node = exprRootNode.getChild(0);
        switch (node.getKind()) {
            case NULL_NODE: {
                return NullData.INSTANCE;
            }
            case BOOLEAN_NODE: {
                return BooleanData.forValue(((BooleanNode)node).getValue());
            }
            case INTEGER_NODE: {
                return IntegerData.forValue(((IntegerNode)node).getValue());
            }
            case FLOAT_NODE: {
                return FloatData.forValue(((FloatNode)node).getValue());
            }
            case STRING_NODE: {
                return StringData.forValue(((StringNode)node).getValue());
            }
        }
        return null;
    }

    private void addConsecutiveRawTextNodesAsOneNodeHelper(SoyNode.BlockNode blockNode, List<RawTextNode> list) {
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            blockNode.addChild((Node)list.get(0));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (RawTextNode rawTextNode : list) {
                stringBuilder.append(rawTextNode.getRawText());
            }
            blockNode.addChild(new RawTextNode(this.nodeIdGen.genId(), stringBuilder.toString()));
        }
    }

    private static void replaceNodeWithList(SoyNode.StandaloneNode standaloneNode, List<? extends SoyNode.StandaloneNode> list) {
        SoyNode.BlockNode blockNode = standaloneNode.getParent();
        int n = blockNode.getChildIndex(standaloneNode);
        blockNode.removeChild(n);
        blockNode.addChildren(n, list);
    }
}

