/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoveHtmlCommentsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern HTML_COMMENT = Pattern.compile("<!--.*?-->");
    private IdGenerator nodeIdGen;

    @Override
    public Void exec(SoyNode soyNode) {
        this.nodeIdGen = null;
        this.visit(soyNode);
        return null;
    }

    @Override
    protected void visitRawTextNode(RawTextNode rawTextNode) {
        Matcher matcher = HTML_COMMENT.matcher(rawTextNode.getRawText());
        if (!matcher.find()) {
            return;
        }
        matcher.reset();
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        if (stringBuffer.length() > 0) {
            if (this.nodeIdGen == null) {
                this.nodeIdGen = rawTextNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
            }
            RawTextNode rawTextNode2 = new RawTextNode(this.nodeIdGen.genId(), stringBuffer.toString());
            rawTextNode.getParent().replaceChild(rawTextNode, rawTextNode2);
        } else {
            rawTextNode.getParent().removeChild(rawTextNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

