/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;

public class FindIndirectParamsVisitor
extends AbstractSoyNodeVisitor<IndirectParamsInfo> {
    private TemplateRegistry templateRegistry;
    private boolean isStartOfPass;
    private Set<CallSituation> visitedCallSituations;
    private TemplateNode currTemplate;
    private Set<TemplateNode> currNewAllCallers;
    private Deque<CallerFrame> callerStack;
    private Map<String, TemplateNode.SoyDocParam> indirectParams;
    private Multimap<String, TemplateNode> paramKeyToCalleesMultimap;
    private boolean mayHaveExternalIndirectParams;

    public FindIndirectParamsVisitor(@Nullable TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    @Override
    public IndirectParamsInfo exec(SoyNode soyNode) {
        this.isStartOfPass = true;
        this.visitedCallSituations = Sets.newHashSet();
        this.currTemplate = null;
        this.callerStack = new ArrayDeque<CallerFrame>();
        this.callerStack.add(new CallerFrame(null, (Set<TemplateNode>)ImmutableSet.of(), (Set<String>)ImmutableSet.of()));
        this.indirectParams = Maps.newHashMap();
        this.paramKeyToCalleesMultimap = HashMultimap.create();
        this.mayHaveExternalIndirectParams = false;
        this.visit(soyNode);
        return new IndirectParamsInfo((SortedMap<String, TemplateNode.SoyDocParam>)ImmutableSortedMap.copyOf(this.indirectParams), this.paramKeyToCalleesMultimap, this.mayHaveExternalIndirectParams);
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        if (this.templateRegistry == null) {
            SoyFileSetNode soyFileSetNode = (SoyFileSetNode)templateNode.getParent().getParent();
            this.templateRegistry = new TemplateRegistry(soyFileSetNode);
        }
        if (this.isStartOfPass) {
            this.isStartOfPass = false;
        } else {
            for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
                if (this.callerStack.peek().allCallParamKeys.contains(soyDocParam.key)) continue;
                if (!this.indirectParams.containsKey(soyDocParam.key)) {
                    this.indirectParams.put(soyDocParam.key, soyDocParam);
                }
                this.paramKeyToCalleesMultimap.put((Object)soyDocParam.key, (Object)templateNode);
            }
        }
        this.currTemplate = templateNode;
        this.currNewAllCallers = null;
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode callBasicNode) {
        this.visitChildren(callBasicNode);
        if (!callBasicNode.isPassingAllData()) {
            return;
        }
        TemplateBasicNode templateBasicNode = this.templateRegistry.getBasicTemplate(callBasicNode.getCalleeName());
        if (templateBasicNode == null) {
            this.mayHaveExternalIndirectParams = true;
            return;
        }
        this.visitCalleeHelper(callBasicNode, templateBasicNode);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode callDelegateNode) {
        this.visitChildren(callDelegateNode);
        if (!callDelegateNode.isPassingAllData()) {
            return;
        }
        this.mayHaveExternalIndirectParams = true;
        List<TemplateRegistry.DelegateTemplateDivision> list = this.templateRegistry.getSortedDelegateTemplateDivisions(callDelegateNode.getDelCalleeName());
        if (list != null) {
            for (TemplateRegistry.DelegateTemplateDivision delegateTemplateDivision : list) {
                for (TemplateDelegateNode templateDelegateNode : delegateTemplateDivision.delPackageNameToDelTemplateMap.values()) {
                    this.visitCalleeHelper(callDelegateNode, templateDelegateNode);
                }
            }
        }
    }

    private void visitCalleeHelper(CallNode callNode, TemplateNode templateNode) {
        Object object;
        Object object2;
        Object object32;
        if (templateNode == this.currTemplate || this.callerStack.peek().allCallers.contains(templateNode)) {
            return;
        }
        Set<String> set = this.callerStack.peek().allCallParamKeys;
        HashSet hashSet = Sets.newHashSet();
        for (Object object32 : callNode.getChildren()) {
            object2 = ((CallParamNode)object32).getKey();
            if (set.contains(object2)) continue;
            hashSet.add(object2);
        }
        if (hashSet.size() > 0) {
            object = Sets.newHashSet(set);
            object.addAll(hashSet);
        } else {
            object = set;
        }
        object32 = new CallSituation(templateNode, (Set<String>)object);
        if (this.visitedCallSituations.contains(object32)) {
            return;
        }
        this.visitedCallSituations.add((CallSituation)object32);
        if (this.currNewAllCallers == null) {
            this.currNewAllCallers = Sets.newHashSet(this.callerStack.peek().allCallers);
            this.currNewAllCallers.add(this.currTemplate);
        }
        object2 = new CallerFrame(this.currTemplate, this.currNewAllCallers, (Set<String>)object);
        this.callerStack.push((CallerFrame)object2);
        this.visit(templateNode);
        CallerFrame callerFrame = this.callerStack.pop();
        if (callerFrame != object2) {
            throw new AssertionError();
        }
        this.currTemplate = ((CallerFrame)object2).caller;
        this.currNewAllCallers = ((CallerFrame)object2).allCallers;
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }

    private static class CallSituation {
        private final TemplateNode callee;
        private final Set<String> allCallParamKeys;

        public CallSituation(TemplateNode templateNode, Set<String> set) {
            this.callee = templateNode;
            this.allCallParamKeys = set;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            CallSituation callSituation = (CallSituation)object;
            return callSituation.callee == this.callee && ((Object)callSituation.allCallParamKeys).equals(this.allCallParamKeys);
        }

        public int hashCode() {
            return this.callee.hashCode() * 31 + ((Object)this.allCallParamKeys).hashCode();
        }
    }

    private static class CallerFrame {
        public final TemplateNode caller;
        public final Set<TemplateNode> allCallers;
        public final Set<String> allCallParamKeys;

        public CallerFrame(TemplateNode templateNode, Set<TemplateNode> set, Set<String> set2) {
            this.caller = templateNode;
            this.allCallers = set;
            this.allCallParamKeys = set2;
        }
    }

    public static class IndirectParamsInfo {
        public final SortedMap<String, TemplateNode.SoyDocParam> indirectParams;
        public final Multimap<String, TemplateNode> paramKeyToCalleesMultimap;
        public final boolean mayHaveExternalIndirectParams;

        public IndirectParamsInfo(SortedMap<String, TemplateNode.SoyDocParam> sortedMap, Multimap<String, TemplateNode> multimap, boolean bl) {
            this.indirectParams = sortedMap;
            this.paramKeyToCalleesMultimap = multimap;
            this.mayHaveExternalIndirectParams = bl;
        }
    }
}

