/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.FindIndirectParamsVisitor;
import com.google.template.soy.sharedpasses.MarkLocalVarDataRefsVisitor;
import com.google.template.soy.sharedpasses.UnmarkLocalVarDataRefsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CheckSoyDocVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final boolean isTreeAllV2;
    private TemplateRegistry templateRegistry;
    private boolean currFileHasOptParams;
    private boolean usesFunctionHasData;
    private GetDataKeysInExprVisitor getDataKeysInExprVisitor;

    public CheckSoyDocVisitor(boolean bl) {
        this.isTreeAllV2 = bl;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        new MarkLocalVarDataRefsVisitor().exec(soyNode);
        super.exec(soyNode);
        new UnmarkLocalVarDataRefsVisitor().exec(soyNode);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        this.templateRegistry = new TemplateRegistry(soyFileSetNode);
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            boolean bl;
            if (this.isTreeAllV2) {
                bl = true;
            } else {
                try {
                    new AssertSyntaxVersionV2Visitor().exec(soyFileNode);
                    bl = true;
                }
                catch (SoySyntaxException soySyntaxException) {
                    bl = false;
                }
            }
            if (!bl) continue;
            this.visit(soyFileNode);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFileNode) {
        this.currFileHasOptParams = false;
        block0: for (TemplateNode templateNode : soyFileNode.getChildren()) {
            for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
                if (soyDocParam.isRequired) continue;
                this.currFileHasOptParams = true;
                break block0;
            }
        }
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        this.usesFunctionHasData = false;
        HashSet hashSet = Sets.newHashSet();
        this.getDataKeysInExprVisitor = new GetDataKeysInExprVisitor(hashSet);
        this.visitChildren(templateNode);
        FindIndirectParamsVisitor.IndirectParamsInfo indirectParamsInfo = new FindIndirectParamsVisitor(this.templateRegistry).exec(templateNode);
        ArrayList arrayList = Lists.newArrayList();
        for (TemplateNode.SoyDocParam object : templateNode.getSoyDocParams()) {
            if (hashSet.contains(object.key)) {
                hashSet.remove(object.key);
                continue;
            }
            if (indirectParamsInfo.paramKeyToCalleesMultimap.containsKey((Object)object.key) || indirectParamsInfo.mayHaveExternalIndirectParams) continue;
            arrayList.add(object.key);
        }
        ArrayList arrayList2 = Lists.newArrayList();
        if (hashSet.size() > 0) {
            arrayList2.addAll(hashSet);
            Collections.sort(arrayList2);
        }
        if (arrayList2.size() > 0) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Found references to data keys that are not declared in SoyDoc: " + arrayList2, null, templateNode);
        }
        if (arrayList.size() > 0 && !(templateNode instanceof TemplateDelegateNode)) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Found params declared in SoyDoc but not used in template: " + arrayList, null, templateNode);
        }
        if (this.currFileHasOptParams && this.usesFunctionHasData) {
            for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
                if (!soyDocParam.isRequired) continue;
                throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Unnecessary usage of hasData() since template has at least one required parameter.", null, templateNode);
            }
        }
    }

    @Override
    protected void visitCallNode(CallNode callNode) {
        if (!callNode.isPassingAllData()) {
            this.visitExprHolderHelper(callNode);
        }
        this.visitChildren(callNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ExprHolderNode) {
            this.visitExprHolderHelper((SoyNode.ExprHolderNode)soyNode);
        }
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }

    private void visitExprHolderHelper(SoyNode.ExprHolderNode exprHolderNode) {
        for (ExprUnion exprUnion : exprHolderNode.getAllExprUnions()) {
            ExprRootNode<?> exprRootNode = exprUnion.getExpr();
            if (this.currFileHasOptParams && !this.usesFunctionHasData && new UsesFunctionHasDataVisitor().exec(exprRootNode).booleanValue()) {
                this.usesFunctionHasData = true;
            }
            this.getDataKeysInExprVisitor.exec(exprRootNode);
        }
    }

    private static class GetDataKeysInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final Set<String> dataKeys;

        public GetDataKeysInExprVisitor(Set<String> set) {
            this.dataKeys = set;
        }

        @Override
        protected void visitDataRefNode(DataRefNode dataRefNode) {
            if (!dataRefNode.isIjDataRef() && !dataRefNode.isLocalVarDataRef().booleanValue()) {
                this.dataKeys.add(dataRefNode.getFirstKey());
            }
            this.visitChildren(dataRefNode);
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)exprNode);
            }
        }
    }

    private static class UsesFunctionHasDataVisitor
    extends AbstractExprNodeVisitor<Boolean> {
        private boolean usesFunctionHasData;

        private UsesFunctionHasDataVisitor() {
        }

        @Override
        public Boolean exec(ExprNode exprNode) {
            this.usesFunctionHasData = false;
            this.visit(exprNode);
            return this.usesFunctionHasData;
        }

        @Override
        protected void visitFunctionNode(FunctionNode functionNode) {
            if (functionNode.getFunctionName().equals("hasData")) {
                this.usesFunctionHasData = true;
            }
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                for (ExprNode exprNode2 : ((ExprNode.ParentExprNode)exprNode).getChildren()) {
                    if (this.usesFunctionHasData) {
                        return;
                    }
                    this.visit(exprNode2);
                }
            }
        }
    }
}

