/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BuildAllDependeesMapVisitor
extends AbstractSoyNodeVisitor<Map<SoyNode, List<SoyNode>>> {
    private Deque<List<SoyNode>> potentialDependeeFrames;
    private Map<SoyNode, List<SoyNode>> allDependeesMap;
    private static final Pattern TOP_LEVEL_REF = Pattern.compile("\\$([a-zA-Z0-9_]+)");

    @Override
    public Map<SoyNode, List<SoyNode>> exec(SoyNode soyNode) {
        Preconditions.checkArgument((soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode || soyNode instanceof TemplateNode ? 1 : 0) != 0);
        this.allDependeesMap = Maps.newHashMap();
        this.visit(soyNode);
        return this.allDependeesMap;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFileNode) {
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        this.potentialDependeeFrames = new ArrayDeque<List<SoyNode>>();
        this.potentialDependeeFrames.push(Lists.newArrayList((Object[])new SoyNode[]{templateNode}));
        this.visitChildren(templateNode);
        this.potentialDependeeFrames.pop();
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode googMsgNode) {
        this.visitSoyNode(googMsgNode);
        this.potentialDependeeFrames.peek().add(googMsgNode);
    }

    @Override
    protected void visitLetNode(LetNode letNode) {
        this.visitSoyNode(letNode);
        this.potentialDependeeFrames.peek().add(letNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        AbstractCollection abstractCollection;
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            abstractCollection = Lists.newArrayList();
            if (soyNode instanceof TemplateNode || soyNode instanceof SoyNode.SplitLevelTopNode || soyNode instanceof SoyNode.ConditionalBlockNode || soyNode instanceof SoyNode.LocalVarBlockNode || soyNode instanceof SoyNode.MsgBlockNode) {
                abstractCollection.add(soyNode);
            }
            this.potentialDependeeFrames.push((List<SoyNode>)((Object)abstractCollection));
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
            this.potentialDependeeFrames.pop();
        }
        if (soyNode instanceof SoyNode.ExprHolderNode) {
            abstractCollection = Sets.newHashSet();
            for (ExprUnion object : ((SoyNode.ExprHolderNode)soyNode).getAllExprUnions()) {
                abstractCollection.addAll(BuildAllDependeesMapVisitor.getTopLevelRefsInExpr(object));
            }
        } else {
            abstractCollection = null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (List<SoyNode> list : this.potentialDependeeFrames) {
            for (int i = list.size() - 1; i >= 0; --i) {
                SoyNode soyNode2 = list.get(i);
                if (!this.isDependent(soyNode2, soyNode, (Set<String>)((Object)abstractCollection))) continue;
                arrayList.add(soyNode2);
            }
        }
        this.allDependeesMap.put(soyNode, arrayList);
        if (arrayList.size() == 0) {
            throw new AssertionError();
        }
    }

    private boolean isDependent(SoyNode soyNode, SoyNode soyNode2, @Nullable Set<String> set) {
        if (soyNode instanceof TemplateNode || soyNode instanceof SoyNode.ConditionalBlockNode && !(soyNode instanceof SoyNode.LoopNode)) {
            return true;
        }
        if (soyNode2.getParent() == soyNode && (soyNode instanceof SoyNode.SplitLevelTopNode || soyNode instanceof SoyNode.MsgBlockNode)) {
            return true;
        }
        if (soyNode instanceof SoyNode.LocalVarNode) {
            if (set != null && set.contains(((SoyNode.LocalVarNode)soyNode).getVarName())) {
                return true;
            }
            if (soyNode2 instanceof SoyNode.ParentSoyNode) {
                for (SoyNode soyNode3 : ((SoyNode.ParentSoyNode)soyNode2).getChildren()) {
                    List<SoyNode> list = this.allDependeesMap.get(soyNode3);
                    if (list == null) {
                        throw new AssertionError((Object)"Child has not been visited.");
                    }
                    if (!list.contains(soyNode)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Set<String> getTopLevelRefsInExpr(ExprUnion exprUnion) {
        if (exprUnion.getExpr() != null) {
            return new GetTopLevelRefsInExprVisitor().exec(exprUnion.getExpr());
        }
        return BuildAllDependeesMapVisitor.getTopLevelRefsInV1Expr(exprUnion.getExprText());
    }

    private static Set<String> getTopLevelRefsInV1Expr(String string) {
        HashSet hashSet = Sets.newHashSet();
        Matcher matcher = TOP_LEVEL_REF.matcher(string);
        while (matcher.find()) {
            hashSet.add(matcher.group(1));
        }
        return hashSet;
    }

    private static class GetTopLevelRefsInExprVisitor
    extends AbstractExprNodeVisitor<Set<String>> {
        private Set<String> topLevelRefs;

        private GetTopLevelRefsInExprVisitor() {
        }

        @Override
        public Set<String> exec(ExprNode exprNode) {
            this.topLevelRefs = Sets.newHashSet();
            this.visit(exprNode);
            return this.topLevelRefs;
        }

        @Override
        protected void visitDataRefNode(DataRefNode dataRefNode) {
            this.topLevelRefs.add(dataRefNode.getFirstKey());
            this.visitChildren(dataRefNode);
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)exprNode);
            }
        }
    }
}

