/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.shared.restricted.EscapingConventions;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public final class Sanitizers {
    private static final Logger LOGGER = Logger.getLogger(Sanitizers.class.getName());

    private Sanitizers() {
    }

    public static String escapeHtml(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.HTML)) {
            return soyData.toString();
        }
        return Sanitizers.escapeHtml(soyData.toString());
    }

    public static String escapeHtml(String string) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(string);
    }

    public static String escapeHtmlRcdata(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.normalizeHtml(soyData.toString());
        }
        return Sanitizers.escapeHtml(soyData.toString());
    }

    public static String escapeHtmlRcdata(String string) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(string);
    }

    public static String normalizeHtml(SoyData soyData) {
        return Sanitizers.normalizeHtml(soyData.toString());
    }

    public static String normalizeHtml(String string) {
        return EscapingConventions.NormalizeHtml.INSTANCE.escape(string);
    }

    public static String normalizeHtmlNospace(SoyData soyData) {
        return Sanitizers.normalizeHtmlNospace(soyData.toString());
    }

    public static String normalizeHtmlNospace(String string) {
        return EscapingConventions.NormalizeHtmlNospace.INSTANCE.escape(string);
    }

    public static String escapeHtmlAttribute(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(soyData.toString(), true);
        }
        return Sanitizers.escapeHtmlAttribute(soyData.toString());
    }

    public static String escapeHtmlAttribute(String string) {
        return EscapingConventions.EscapeHtml.INSTANCE.escape(string);
    }

    public static String escapeHtmlAttributeNospace(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.HTML)) {
            return Sanitizers.stripHtmlTags(soyData.toString(), false);
        }
        return Sanitizers.escapeHtmlAttributeNospace(soyData.toString());
    }

    public static String escapeHtmlAttributeNospace(String string) {
        return EscapingConventions.EscapeHtmlNospace.INSTANCE.escape(string);
    }

    public static String escapeJsString(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.JS_STR_CHARS)) {
            return soyData.toString();
        }
        return Sanitizers.escapeJsString(soyData.toString());
    }

    public static String escapeJsString(String string) {
        return EscapingConventions.EscapeJsString.INSTANCE.escape(string);
    }

    public static String escapeJsValue(SoyData soyData) {
        if (NullData.INSTANCE == soyData) {
            return " null ";
        }
        if (soyData instanceof NumberData) {
            return " " + soyData.numberValue() + " ";
        }
        if (soyData instanceof BooleanData) {
            return " " + soyData.booleanValue() + " ";
        }
        return Sanitizers.escapeJsValue(soyData.toString());
    }

    public static String escapeJsValue(String string) {
        return string != null ? "'" + Sanitizers.escapeJsString(string) + "'" : " null ";
    }

    public static String escapeJsRegex(SoyData soyData) {
        return Sanitizers.escapeJsRegex(soyData.toString());
    }

    public static String escapeJsRegex(String string) {
        return EscapingConventions.EscapeJsRegex.INSTANCE.escape(string);
    }

    public static String escapeCssString(SoyData soyData) {
        return Sanitizers.escapeCssString(soyData.toString());
    }

    public static String escapeCssString(String string) {
        return EscapingConventions.EscapeCssString.INSTANCE.escape(string);
    }

    public static String filterCssValue(SoyData soyData) {
        return NullData.INSTANCE == soyData ? "" : Sanitizers.filterCssValue(soyData.toString());
    }

    public static String filterCssValue(String string) {
        if (EscapingConventions.FilterCssValue.INSTANCE.getValueFilter().matcher(string).find()) {
            return string;
        }
        LOGGER.log(Level.WARNING, "|filterCssValue received bad value {0}", string);
        return "zSoyz";
    }

    public static String escapeUri(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.URI)) {
            return Sanitizers.filterNormalizeUri(soyData);
        }
        return Sanitizers.escapeUri(soyData.toString());
    }

    public static String escapeUri(String string) {
        return CharEscapers.uriEscaper(false).escape(string);
    }

    public static String normalizeUri(SoyData soyData) {
        return Sanitizers.normalizeUri(soyData.toString());
    }

    public static String normalizeUri(String string) {
        return EscapingConventions.NormalizeUri.INSTANCE.escape(string);
    }

    public static String filterNormalizeUri(SoyData soyData) {
        return Sanitizers.filterNormalizeUri(soyData.toString());
    }

    public static String filterNormalizeUri(String string) {
        if (EscapingConventions.FilterNormalizeUri.INSTANCE.getValueFilter().matcher(string).find()) {
            return EscapingConventions.FilterNormalizeUri.INSTANCE.escape(string);
        }
        LOGGER.log(Level.WARNING, "|filterNormalizeUri received bad value {0}", string);
        return "#zSoyz";
    }

    public static String filterHtmlAttribute(SoyData soyData) {
        if (Sanitizers.isSanitizedContentOfKind(soyData, SanitizedContent.ContentKind.HTML_ATTRIBUTE)) {
            String string = soyData.toString();
            int n = string.indexOf(61);
            if (n != -1) {
                switch (string.charAt(string.length() - 1)) {
                    case '\"': 
                    case '\'': {
                        break;
                    }
                    default: {
                        return string.substring(0, n) + "=\"" + string.substring(n + 1) + "\"";
                    }
                }
            }
            return string;
        }
        return Sanitizers.filterHtmlAttribute(soyData.toString());
    }

    public static String filterHtmlAttribute(String string) {
        if (EscapingConventions.FilterHtmlAttribute.INSTANCE.getValueFilter().matcher(string).find()) {
            return string;
        }
        LOGGER.log(Level.WARNING, "|filterHtmlAttribute received bad value {0}", string);
        return "zSoyz";
    }

    public static String filterHtmlElementName(SoyData soyData) {
        return Sanitizers.filterHtmlElementName(soyData.toString());
    }

    public static String filterHtmlElementName(String string) {
        if (EscapingConventions.FilterHtmlElementName.INSTANCE.getValueFilter().matcher(string).find()) {
            return string;
        }
        LOGGER.log(Level.WARNING, "|filterHtmlElementName received bad value {0}", string);
        return "zSoyz";
    }

    private static boolean isSanitizedContentOfKind(SoyData soyData, SanitizedContent.ContentKind contentKind) {
        return soyData instanceof SanitizedContent && contentKind == ((SanitizedContent)soyData).getContentKind();
    }

    @VisibleForTesting
    static String stripHtmlTags(String string, boolean bl) {
        EscapingConventions.CrossLanguageStringXform crossLanguageStringXform = bl ? EscapingConventions.NormalizeHtml.INSTANCE : EscapingConventions.NormalizeHtmlNospace.INSTANCE;
        Matcher matcher = EscapingConventions.HTML_TAG_CONTENT.matcher(string);
        if (!matcher.find()) {
            return crossLanguageStringXform.escape(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() - matcher.end() + matcher.start());
        Appendable appendable = crossLanguageStringXform.escape(stringBuilder);
        try {
            int n = 0;
            do {
                appendable.append(string, n, matcher.start());
                n = matcher.end();
            } while (matcher.find());
            appendable.append(string, n, string.length());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }
}

