/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum NonpluginFunction {
    IS_FIRST(1),
    IS_LAST(1),
    INDEX(1),
    HAS_DATA(0);

    private static final Map<String, NonpluginFunction> NONPLUGIN_FUNCTIONS_BY_NAME;
    private final String functionName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    private final int numArgs;

    public static NonpluginFunction forFunctionName(String string) {
        return NONPLUGIN_FUNCTIONS_BY_NAME.get(string);
    }

    private NonpluginFunction(int n2) {
        this.numArgs = n2;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NonpluginFunction nonpluginFunction : NonpluginFunction.values()) {
            builder.put((Object)nonpluginFunction.getFunctionName(), (Object)nonpluginFunction);
        }
        NONPLUGIN_FUNCTIONS_BY_NAME = builder.build();
    }
}

