/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.google.template.soy.SoyUtils;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

public class SoyGeneralOptions
implements Cloneable {
    private CssHandlingScheme cssHandlingScheme = CssHandlingScheme.LITERAL;
    private ImmutableMap<String, PrimitiveData> compileTimeGlobals = null;

    public void setCssHandlingScheme(CssHandlingScheme cssHandlingScheme) {
        this.cssHandlingScheme = cssHandlingScheme;
    }

    public CssHandlingScheme getCssHandlingScheme() {
        return this.cssHandlingScheme;
    }

    public void setCompileTimeGlobals(Map<String, ?> map) {
        this.setCompileTimeGlobalsInternal(DataUtils.convertCompileTimeGlobalsMap(map));
    }

    private void setCompileTimeGlobalsInternal(ImmutableMap<String, PrimitiveData> immutableMap) {
        Preconditions.checkState((this.compileTimeGlobals == null ? 1 : 0) != 0, (Object)"Compile-time globals already set.");
        this.compileTimeGlobals = immutableMap;
    }

    public void setCompileTimeGlobals(File file) throws IOException {
        this.setCompileTimeGlobalsInternal(SoyUtils.parseCompileTimeGlobals((InputSupplier<? extends Reader>)Files.newReaderSupplier((File)file, (Charset)Charsets.UTF_8)));
    }

    public void setCompileTimeGlobals(URL uRL) throws IOException {
        this.setCompileTimeGlobalsInternal(SoyUtils.parseCompileTimeGlobals((InputSupplier<? extends Reader>)Resources.newReaderSupplier((URL)uRL, (Charset)Charsets.UTF_8)));
    }

    public ImmutableMap<String, PrimitiveData> getCompileTimeGlobals() {
        return this.compileTimeGlobals;
    }

    public SoyGeneralOptions clone() {
        try {
            return (SoyGeneralOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Cloneable interface removed from SoyGeneralOptions");
        }
    }

    public static enum CssHandlingScheme {
        LITERAL,
        REFERENCE,
        BACKEND_SPECIFIC;

    }
}

