/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public final class SoyAutoescapeException
extends SoySyntaxException {
    public SoyAutoescapeException(SoyNode soyNode, String string, Throwable throwable) {
        super(string, throwable);
        if (soyNode != null) {
            this.setContextNode(soyNode);
        }
    }

    public SoyAutoescapeException(SoyNode soyNode, String string) {
        this(soyNode, string, null);
    }

    public SoyAutoescapeException(String string, Throwable throwable) {
        this(null, string, throwable);
    }

    public SoyAutoescapeException(String string) {
        this(null, string, null);
    }

    public void setContextNode(SoyNode soyNode) {
        SourceLocation sourceLocation;
        TemplateNode templateNode = soyNode.getNearestAncestor(TemplateNode.class);
        if (templateNode != null) {
            this.setTemplateName(templateNode.getTemplateNameForUserMsgs());
        }
        if ((sourceLocation = soyNode.getLocation()).isKnown()) {
            this.setSourceLocation(sourceLocation);
        } else {
            SoyFileNode soyFileNode = soyNode.getNearestAncestor(SoyFileNode.class);
            this.setFilePath(soyFileNode.getFilePath());
        }
    }

    public void maybeSetContextNode(SoyNode soyNode) {
        if (!this.getSourceLocation().isKnown()) {
            this.setContextNode(soyNode);
        }
    }
}

