/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.parsepasses.contextautoesc.EscapingMode;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Rewriter {
    private final Inferences inferences;
    private final Set<String> visitedTemplateNames = Sets.newHashSet();
    private final Map<String, SanitizedContent.ContentKind> sanitizedContentOperators;

    public Rewriter(Inferences inferences, Map<String, SanitizedContent.ContentKind> map) {
        this.inferences = inferences;
        this.sanitizedContentOperators = map;
    }

    public List<TemplateNode> rewrite(SoyFileSetNode soyFileSetNode) {
        RewriterVisitor rewriterVisitor = new RewriterVisitor();
        for (Object object : soyFileSetNode.getChildren()) {
            rewriterVisitor.exec(object);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateNode templateNode : this.inferences.getAllTemplates()) {
            String string = templateNode.getTemplateName();
            if (this.visitedTemplateNames.contains(string)) continue;
            builder.add((Object)templateNode);
            rewriterVisitor.exec(templateNode);
        }
        return builder.build();
    }

    private static void replaceChild(SoyNode.StandaloneNode standaloneNode, SoyNode.StandaloneNode standaloneNode2) {
        standaloneNode.getParent().replaceChild(standaloneNode, standaloneNode2);
    }

    private static <T extends SoyNode> void moveChildrenTo(SoyNode.ParentSoyNode<T> parentSoyNode, SoyNode.ParentSoyNode<T> parentSoyNode2) {
        ImmutableList immutableList = ImmutableList.copyOf(parentSoyNode.getChildren());
        parentSoyNode.clearChildren();
        parentSoyNode2.addChildren((List<T>)immutableList);
    }

    final class RewriterVisitor
    extends AbstractSoyNodeVisitor<Void> {
        RewriterVisitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode templateNode) {
            Rewriter.this.visitedTemplateNames.add(templateNode.getTemplateName());
            this.visitChildrenAllowingConcurrentModification(templateNode);
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            int n = printNode.getId();
            ImmutableList<EscapingMode> immutableList = Rewriter.this.inferences.getEscapingModesForId(n);
            for (EscapingMode escapingMode : immutableList) {
                int n2;
                PrintDirectiveNode printDirectiveNode = new PrintDirectiveNode(Rewriter.this.inferences.getIdGenerator().genId(), escapingMode.directiveName, "");
                printDirectiveNode.setLocation(printNode.getLocation());
                for (n2 = printNode.numChildren(); n2 > 0; --n2) {
                    String string = ((PrintDirectiveNode)printNode.getChild(n2 - 1)).getName();
                    SanitizedContent.ContentKind contentKind = (SanitizedContent.ContentKind)((Object)Rewriter.this.sanitizedContentOperators.get(string));
                    if (contentKind == null || contentKind != escapingMode.contentKind) break;
                }
                printNode.addChild(n2, printDirectiveNode);
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            String string = Rewriter.this.inferences.getDerivedCalleeNameForCallId(callNode.getId());
            if (string != null) {
                CallNode callNode2;
                String string2 = null;
                if (callNode instanceof CallBasicNode) {
                    int n;
                    string2 = ((CallBasicNode)callNode).getPartialCalleeName();
                    String string3 = null;
                    if (string2 != null && (n = string.lastIndexOf(46)) >= 0) {
                        string3 = string.substring(n);
                    }
                    callNode2 = new CallBasicNode(callNode.getId(), string, string3, false, callNode.isPassingData(), callNode.isPassingAllData(), callNode.getExprText(), callNode.getUserSuppliedPlaceholderName(), callNode.getSyntaxVersion());
                } else {
                    callNode2 = new CallDelegateNode(callNode.getId(), string, false, callNode.isPassingData(), callNode.isPassingAllData(), callNode.getExprText(), callNode.getUserSuppliedPlaceholderName());
                }
                if (!callNode.getCommandText().equals(callNode2.getCommandText())) {
                    callNode2.setLocation(callNode.getLocation());
                    Rewriter.moveChildrenTo(callNode, callNode2);
                    Rewriter.replaceChild(callNode, callNode2);
                }
            }
            this.visitChildrenAllowingConcurrentModification(callNode);
        }

        @Override
        protected void visitSoyNode(SoyNode soyNode) {
            if (soyNode instanceof SoyNode.ParentSoyNode) {
                this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)soyNode);
            }
        }
    }
}

