/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.JsUtil;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RawTextContextUpdater {
    private int numCharsConsumed;
    private Context next;
    private static Set<String> URI_ATTR_NAMES = ImmutableSet.of((Object)"action", (Object)"archive", (Object)"background", (Object)"cite", (Object)"classid", (Object)"codebase", (Object[])new String[]{"data", "dsync", "href", "longdesc", "src", "usemap", "entity"});
    private static Pattern CUSTOM_URI_ATTR_NAMING_CONVENTION = Pattern.compile("\\bur[il]|ur[il]s?$");
    private static final Transition TRANSITION_TO_SELF = RawTextContextUpdater.makeTransitionToSelf("\\z");
    private static final Transition URI_PART_TRANSITION = new Transition("[?#]|\\z"){

        @Override
        boolean isApplicableTo(Context context, Matcher matcher) {
            return true;
        }

        @Override
        Context computeNextContext(Context context, Matcher matcher) {
            Context.UriPart uriPart = context.uriPart;
            if (uriPart == Context.UriPart.START) {
                uriPart = Context.UriPart.PRE_QUERY;
            }
            if (uriPart != Context.UriPart.FRAGMENT) {
                String string = matcher.group(0);
                if ("?".equals(string) && uriPart != Context.UriPart.UNKNOWN) {
                    uriPart = Context.UriPart.QUERY;
                } else if ("#".equals(string)) {
                    uriPart = Context.UriPart.FRAGMENT;
                }
            }
            return context.derive(uriPart);
        }
    };
    private static final String JS_LINEBREAKS = "\r\n\u2028\u2029";
    private static final Map<Context.State, List<Transition>> TRANSITIONS = ImmutableMap.builder().put((Object)Context.State.HTML_PCDATA, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionTo("<!--", Context.HTML_COMMENT), (Object)RawTextContextUpdater.makeTransitionToTag("(?i)<script(?=[\\s>/]|\\z)", Context.ElementType.SCRIPT), (Object)RawTextContextUpdater.makeTransitionToTag("(?i)<style(?=[\\s>/]|\\z)", Context.ElementType.STYLE), (Object)RawTextContextUpdater.makeTransitionToTag("(?i)<textarea(?=[\\s>/]|\\z)", Context.ElementType.TEXTAREA), (Object)RawTextContextUpdater.makeTransitionToTag("(?i)<title(?=[\\s>/]|\\z)", Context.ElementType.TITLE), (Object)RawTextContextUpdater.makeTransitionToTag("(?i)<xmp(?=[\\s>/]|\\z)", Context.ElementType.XMP), (Object)RawTextContextUpdater.makeTransitionTo("</?", Context.HTML_BEFORE_TAG_NAME), (Object)RawTextContextUpdater.makeTransitionToSelf("[^<]+"))).put((Object)Context.State.HTML_BEFORE_TAG_NAME, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionTo("^[a-zA-Z]+", Context.HTML_TAG_NAME), (Object)RawTextContextUpdater.makeTransitionTo("^(?=[^a-zA-Z])", Context.HTML_PCDATA))).put((Object)Context.State.HTML_TAG_NAME, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToSelf("^[a-zA-Z0-9:-]*(?:[a-zA-Z0-9]|\\z)"), (Object)RawTextContextUpdater.makeTransitionToTag("^(?=[/\\s>])", Context.ElementType.NORMAL))).put((Object)Context.State.HTML_TAG, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToAttrName("(?i)^\\s*([a-z](?:[a-z0-9_:\\-]*[a-z0-9])?)"), (Object)new Transition("^\\s*/?>"){

        @Override
        Context computeNextContext(Context context, Matcher matcher) {
            switch (context.elType) {
                case SCRIPT: {
                    return Context.JS;
                }
                case STYLE: {
                    return Context.CSS;
                }
                case NORMAL: {
                    return Context.HTML_PCDATA;
                }
                case NONE: {
                    throw new IllegalStateException();
                }
                case LISTING: 
                case TEXTAREA: 
                case TITLE: 
                case XMP: {
                    return new Context(Context.State.HTML_RCDATA, context.elType, Context.AttributeType.NONE, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
                }
            }
            throw new AssertionError((Object)("Unrecognized state " + (Object)((Object)context.elType)));
        }
    }, (Object)RawTextContextUpdater.makeTransitionToSelf("^\\s+\\z"))).put((Object)Context.State.HTML_ATTRIBUTE_NAME, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("^\\s*=", Context.State.HTML_BEFORE_ATTRIBUTE_VALUE), (Object)RawTextContextUpdater.makeTransitionBackToTag("^"))).put((Object)Context.State.HTML_BEFORE_ATTRIBUTE_VALUE, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToAttrValue("^\\s*\"", Context.AttributeEndDelimiter.DOUBLE_QUOTE), (Object)RawTextContextUpdater.makeTransitionToAttrValue("^\\s*'", Context.AttributeEndDelimiter.SINGLE_QUOTE), (Object)RawTextContextUpdater.makeTransitionToAttrValue("^(?=[^\"'\\s>])", Context.AttributeEndDelimiter.SPACE_OR_TAG_END), (Object)RawTextContextUpdater.makeTransitionBackToTag("^(?=>|\\s+[\\w-]+\\s*=)"), (Object)RawTextContextUpdater.makeTransitionToSelf("^\\s+"))).put((Object)Context.State.HTML_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionTo("-->", Context.HTML_PCDATA), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.HTML_NORMAL_ATTR_VALUE, (Object)ImmutableList.of((Object)TRANSITION_TO_SELF)).put((Object)Context.State.CSS, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("/\\*", Context.State.CSS_COMMENT), (Object)RawTextContextUpdater.makeTransitionToState("\"", Context.State.CSS_DQ_STRING), (Object)RawTextContextUpdater.makeTransitionToState("'", Context.State.CSS_SQ_STRING), (Object)RawTextContextUpdater.makeCssUriTransition("(?i)\\burl\\s*\\(\\s*(['\"]?)"), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.CSS_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\\*/", Context.State.CSS), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.CSS_DQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\"", Context.State.CSS), (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f\"])"), (Object)RawTextContextUpdater.makeTransitionTo("[\n\r\f]", Context.ERROR), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.CSS_SQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("'", Context.State.CSS), (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f'])"), (Object)RawTextContextUpdater.makeTransitionTo("[\n\r\f]", Context.ERROR), (Object)RawTextContextUpdater.makeEndTagTransition("style"), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.CSS_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("[\\)\\s]", Context.State.CSS), (Object)URI_PART_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToState("[\"']", Context.State.ERROR), (Object)RawTextContextUpdater.makeEndTagTransition("style"))).put((Object)Context.State.CSS_SQ_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("'", Context.State.CSS), (Object)URI_PART_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f'])"), (Object)RawTextContextUpdater.makeTransitionTo("[\n\r\f]", Context.ERROR), (Object)RawTextContextUpdater.makeEndTagTransition("style"))).put((Object)Context.State.CSS_DQ_URI, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\"", Context.State.CSS), (Object)URI_PART_TRANSITION, (Object)RawTextContextUpdater.makeTransitionToSelf("\\\\(?:\r\n?|[\n\f\"])"), (Object)RawTextContextUpdater.makeTransitionTo("[\n\r\f]", Context.ERROR), (Object)RawTextContextUpdater.makeEndTagTransition("style"))).put((Object)Context.State.JS, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("/\\*", Context.State.JS_BLOCK_COMMENT), (Object)RawTextContextUpdater.makeTransitionToState("//", Context.State.JS_LINE_COMMENT), (Object)RawTextContextUpdater.makeTransitionToJsString("\"", Context.State.JS_DQ_STRING), (Object)RawTextContextUpdater.makeTransitionToJsString("'", Context.State.JS_SQ_STRING), (Object)new Transition("/"){

        @Override
        Context computeNextContext(Context context, Matcher matcher) throws SoyAutoescapeException {
            switch (context.slashType) {
                case DIV_OP: {
                    return new Context(Context.State.JS, context.elType, context.attrType, context.delimType, Context.JsFollowingSlash.REGEX, context.uriPart);
                }
                case REGEX: {
                    return new Context(Context.State.JS_REGEX, context.elType, context.attrType, context.delimType, Context.JsFollowingSlash.NONE, context.uriPart);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            matcher.appendTail(stringBuffer);
            throw new SoyAutoescapeException("Slash (/) cannot follow the preceding branches since it is unclear whether the slash is a RegExp literal or division operator.  Please add parentheses in the branches leading to `" + stringBuffer + "`");
        }
    }, (Object)new Transition("(?i)(?:[^</\"'\\s\\\\]|<(?!/script))+"){

        @Override
        Context computeNextContext(Context context, Matcher matcher) {
            return context.derive(JsUtil.isRegexPreceder(matcher.group()) ? Context.JsFollowingSlash.REGEX : Context.JsFollowingSlash.DIV_OP);
        }
    }, (Object)RawTextContextUpdater.makeTransitionToSelf("\\s+"), (Object)RawTextContextUpdater.makeEndTagTransition("script"))).put((Object)Context.State.JS_BLOCK_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("\\*/", Context.State.JS), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.JS_LINE_COMMENT, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeTransitionToState("[\r\n\u2028\u2029]", Context.State.JS), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)TRANSITION_TO_SELF)).put((Object)Context.State.JS_DQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("\""), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)RawTextContextUpdater.makeTransitionToSelf("(?i)^(?:[^\"\\\\\r\n\u2028\u2029<]|\\\\(?:\\r\\n?|[^\\r<]|<(?!/script))|<(?!/script))+"))).put((Object)Context.State.JS_SQ_STRING, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("'"), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)RawTextContextUpdater.makeTransitionToSelf("(?i)^(?:[^'\\\\\r\n\u2028\u2029<]|\\\\(?:\\r\\n?|[^\\r<]|<(?!/script))|<(?!/script))+"))).put((Object)Context.State.JS_REGEX, (Object)ImmutableList.of((Object)RawTextContextUpdater.makeDivPreceder("/"), (Object)RawTextContextUpdater.makeEndTagTransition("script"), (Object)RawTextContextUpdater.makeTransitionToSelf("(?i)^(?:[^\\[\\\\/<\r\n\u2028\u2029]|\\\\[^\r\n\u2028\u2029]|\\\\?<(?!/script)|\\[(?:[^\\]\\\\<\r\n\u2028\u2029]|\\\\(?:[^\r\n\u2028\u2029]))*|\\\\?<(?!/script)\\])+"))).put((Object)Context.State.URI, (Object)ImmutableList.of((Object)URI_PART_TRANSITION)).put((Object)Context.State.HTML_RCDATA, (Object)ImmutableList.of((Object)new Transition("</(\\w+)\\b"){

        @Override
        boolean isApplicableTo(Context context, Matcher matcher) {
            String string = matcher.group(1).toUpperCase(Locale.ENGLISH);
            return context.elType.name().equals(string);
        }

        @Override
        Context computeNextContext(Context context, Matcher matcher) {
            return new Context(Context.State.HTML_TAG, Context.ElementType.NORMAL, Context.AttributeType.NONE, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
        }
    }, (Object)TRANSITION_TO_SELF)).build();

    public static Context processRawText(String string, Context context) throws SoyAutoescapeException {
        while (string.length() != 0) {
            int n = RawTextContextUpdater.findEndOfAttributeValue(string, context.delimType);
            if (n == -1) {
                RawTextContextUpdater rawTextContextUpdater = new RawTextContextUpdater();
                rawTextContextUpdater.processNextToken(string, context);
                string = string.substring(rawTextContextUpdater.numCharsConsumed);
                context = rawTextContextUpdater.next;
                continue;
            }
            int n2 = string.length();
            int n3 = n < n2 ? n + context.delimType.text.length() : -1;
            String string2 = UnescapeUtils.unescapeHtml(string.substring(0, n));
            RawTextContextUpdater rawTextContextUpdater = new RawTextContextUpdater();
            while (string2.length() != 0) {
                rawTextContextUpdater.processNextToken(string2, context);
                string2 = string2.substring(rawTextContextUpdater.numCharsConsumed);
                context = rawTextContextUpdater.next;
            }
            if (n3 != -1) {
                string = string.substring(n3);
                context = new Context(Context.State.HTML_TAG, context.elType, Context.AttributeType.NONE, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
                continue;
            }
            if (n != string.length()) {
                throw new IllegalStateException();
            }
            string = "";
        }
        return context;
    }

    private static int findEndOfAttributeValue(String string, Context.AttributeEndDelimiter attributeEndDelimiter) {
        int n = string.length();
        switch (attributeEndDelimiter) {
            case DOUBLE_QUOTE: 
            case SINGLE_QUOTE: {
                int n2 = string.indexOf(attributeEndDelimiter.text.charAt(0));
                return n2 >= 0 ? n2 : n;
            }
            case SPACE_OR_TAG_END: {
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c != '>' && !Character.isWhitespace(c)) continue;
                    return i;
                }
                return n;
            }
            case NONE: {
                return -1;
            }
        }
        throw new AssertionError((Object)("Unrecognized delimiter " + (Object)((Object)attributeEndDelimiter)));
    }

    private RawTextContextUpdater() {
    }

    private void processNextToken(String string, Context context) throws SoyAutoescapeException {
        if (context.isErrorContext()) {
            this.numCharsConsumed = string.length();
            this.next = context;
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        Transition transition = null;
        Matcher matcher = null;
        for (Transition transition2 : TRANSITIONS.get((Object)context.state)) {
            int n3;
            Matcher matcher2 = transition2.pattern.matcher(string);
            if (!matcher2.find() || (n3 = matcher2.start()) >= n) continue;
            int n4 = matcher2.end();
            if (!transition2.isApplicableTo(context, matcher2)) continue;
            n = n3;
            n2 = n4;
            transition = transition2;
            matcher = matcher2;
        }
        if (transition != null) {
            this.next = transition.computeNextContext(context, matcher);
            this.numCharsConsumed = n2;
        } else {
            this.next = Context.ERROR;
            this.numCharsConsumed = string.length();
        }
        if (this.numCharsConsumed == 0 && this.next.state == context.state) {
            throw new IllegalStateException("Infinite loop at `" + string + "` / " + context);
        }
    }

    private static Transition makeTransitionTo(String string, final Context context) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context2, Matcher matcher) {
                return context;
            }
        };
    }

    private static Transition makeTransitionToTag(String string, final Context.ElementType elementType) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return new Context(Context.State.HTML_TAG, elementType, Context.AttributeType.NONE, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
            }
        };
    }

    private static Transition makeTransitionBackToTag(String string) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return new Context(Context.State.HTML_TAG, context.elType, Context.AttributeType.NONE, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
            }
        };
    }

    private static Transition makeTransitionToAttrName(String string) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                int n;
                String string = matcher.group(1).toLowerCase(Locale.ENGLISH);
                String string2 = string.substring((n = string.lastIndexOf(58)) + 1);
                Context.AttributeType attributeType = string2.startsWith("on") ? Context.AttributeType.SCRIPT : ("style".equals(string2) ? Context.AttributeType.STYLE : (URI_ATTR_NAMES.contains(string2) || CUSTOM_URI_ATTR_NAMING_CONVENTION.matcher(string2).find() || "xmlns".equals(string) || string.startsWith("xmlns:") ? Context.AttributeType.URI : Context.AttributeType.PLAIN_TEXT));
                return new Context(Context.State.HTML_ATTRIBUTE_NAME, context.elType, attributeType, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
            }
        };
    }

    private static Transition makeTransitionToAttrValue(String string, final Context.AttributeEndDelimiter attributeEndDelimiter) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return Context.computeContextAfterAttributeDelimiter(context.elType, context.attrType, attributeEndDelimiter);
            }
        };
    }

    private static Transition makeTransitionToState(String string, final Context.State state) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return context.derive(state).derive(Context.UriPart.NONE);
            }
        };
    }

    private static Transition makeTransitionToJsString(String string, final Context.State state) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return new Context(state, context.elType, context.attrType, context.delimType, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
            }
        };
    }

    private static Transition makeTransitionToSelf(String string) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return context;
            }
        };
    }

    private static Transition makeEndTagTransition(String string) {
        return new Transition("(?i)</" + string + "\\b"){

            @Override
            boolean isApplicableTo(Context context, Matcher matcher) {
                return context.attrType == Context.AttributeType.NONE;
            }

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return new Context(Context.State.HTML_TAG, Context.ElementType.NORMAL, Context.AttributeType.NONE, Context.AttributeEndDelimiter.NONE, Context.JsFollowingSlash.NONE, Context.UriPart.NONE);
            }
        };
    }

    private static Transition makeCssUriTransition(String string) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                String string = matcher.group(1);
                Context.State state = "\"".equals(string) ? Context.State.CSS_DQ_URI : ("'".equals(string) ? Context.State.CSS_SQ_URI : Context.State.CSS_URI);
                return new Context(state, context.elType, context.attrType, context.delimType, context.slashType, Context.UriPart.START);
            }
        };
    }

    private static Transition makeDivPreceder(String string) {
        return new Transition(string){

            @Override
            Context computeNextContext(Context context, Matcher matcher) {
                return new Context(Context.State.JS, context.elType, context.attrType, context.delimType, Context.JsFollowingSlash.DIV_OP, context.uriPart);
            }
        };
    }

    private static abstract class Transition {
        final Pattern pattern;

        Transition(Pattern pattern) {
            this.pattern = pattern;
        }

        Transition(String string) {
            this(Pattern.compile(string, 32));
        }

        boolean isApplicableTo(Context context, Matcher matcher) {
            return true;
        }

        abstract Context computeNextContext(Context var1, Matcher var2) throws SoyAutoescapeException;
    }
}

