/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.EscapingMode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class Inferences {
    @Nullable
    private final Inferences parent;
    private final ImmutableSet<String> soyEscapingDirectives;
    private final IdGenerator idGen;
    private final Map<String, List<TemplateNode>> templatesByName = Maps.newLinkedHashMap();
    private final Map<String, Context> templateNameToEndContext = Maps.newLinkedHashMap();
    private final Map<Integer, ImmutableList<EscapingMode>> idToEscapingModes = Maps.newLinkedHashMap();
    private final Map<Integer, String> callIdToDerivedCalleeName = Maps.newLinkedHashMap();
    private final Set<String> templatesChecked = Sets.newHashSet();

    public Inferences(Inferences inferences) {
        this.parent = inferences;
        this.soyEscapingDirectives = inferences.soyEscapingDirectives;
        this.idGen = inferences.idGen;
    }

    public Inferences(Set<String> set, IdGenerator idGenerator, Map<String, ImmutableList<TemplateNode>> map) {
        this.parent = null;
        this.soyEscapingDirectives = ImmutableSet.copyOf(set);
        this.idGen = idGenerator;
        this.templatesByName.putAll(map);
    }

    public void recordTemplateEndContext(String string, Context context) {
        this.templateNameToEndContext.put(string, context);
    }

    public List<TemplateNode> lookupTemplates(String string) {
        Inferences inferences = this;
        while (inferences != null) {
            List<TemplateNode> list = inferences.templatesByName.get(string);
            if (list != null) {
                return list;
            }
            inferences = inferences.parent;
        }
        return null;
    }

    public Context getTemplateEndContext(String string) {
        Inferences inferences = this;
        while (inferences != null) {
            Context context = inferences.templateNameToEndContext.get(string);
            if (context != null) {
                return context;
            }
            inferences = inferences.parent;
        }
        return null;
    }

    public ImmutableList<EscapingMode> getEscapingMode(PrintNode printNode) {
        int n = printNode.getId();
        Inferences inferences = this;
        while (inferences != null) {
            Iterator iterator = inferences.idToEscapingModes.get(n);
            if (iterator != null) {
                return iterator;
            }
            inferences = inferences.parent;
        }
        inferences = ImmutableList.builder();
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            String string = printDirectiveNode.getName();
            EscapingMode escapingMode = EscapingMode.fromDirective(string);
            if (escapingMode != null) {
                inferences.add((Object)escapingMode);
                continue;
            }
            if (!this.soyEscapingDirectives.contains((Object)string)) continue;
            inferences.add((Object)EscapingMode.NO_AUTOESCAPE);
        }
        return inferences.build();
    }

    public void setEscapingDirectives(PrintNode printNode, List<EscapingMode> list) {
        this.idToEscapingModes.put(printNode.getId(), (ImmutableList<EscapingMode>)ImmutableList.copyOf(list));
    }

    public ImmutableList<EscapingMode> getEscapingModesForId(int n) {
        ImmutableList immutableList = this.idToEscapingModes.get(n);
        if (immutableList == null) {
            immutableList = ImmutableList.of();
        }
        return immutableList;
    }

    public void retargetCall(CallNode callNode, String string) {
        this.callIdToDerivedCalleeName.put(callNode.getId(), string);
    }

    public String getDerivedCalleeNameForCallId(int n) {
        return this.callIdToDerivedCalleeName.get(n);
    }

    public List<TemplateNode> cloneTemplates(String string, String string2) {
        if (this.lookupTemplates(string2) != null) {
            throw new AssertionError((Object)string2);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateNode templateNode : this.lookupTemplates(string)) {
            TemplateNode templateNode2;
            Object object;
            TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = templateNode.getSoyFileHeaderInfo();
            int n = templateNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator().genId();
            boolean bl = templateNode.getCommandText().contains("name=");
            if (templateNode instanceof TemplateBasicNode) {
                object = (TemplateBasicNode)templateNode;
                Object object2 = templateNode.getPartialTemplateName() != null ? string2.substring(soyFileHeaderInfo.namespace.length()) : null;
                templateNode2 = new TemplateBasicNode(n, soyFileHeaderInfo, string2, (String)object2, bl, ((TemplateBasicNode)object).isOverride(), templateNode.isPrivate(), templateNode.getAutoescapeMode(), templateNode.getSoyDoc(), templateNode.getSyntaxVersion());
                if (!string2.equals(templateNode2.getTemplateName()) || !Objects.equal((Object)object2, (Object)templateNode2.getPartialTemplateName())) {
                    throw new AssertionError();
                }
            } else if (templateNode instanceof TemplateDelegateNode) {
                object = (TemplateDelegateNode)templateNode;
                templateNode2 = new TemplateDelegateNode(n, soyFileHeaderInfo, string2, ((TemplateDelegateNode)object).getDelPriority(), templateNode.getAutoescapeMode(), templateNode.getSoyDoc());
                if (!string2.equals(((TemplateDelegateNode)templateNode2).getDelTemplateName())) {
                    throw new AssertionError();
                }
            } else {
                throw new AssertionError((Object)("Unknown template node type: " + templateNode.getClass()));
            }
            templateNode2.setLocation(templateNode.getLocation());
            for (Object object2 : templateNode.getChildren()) {
                templateNode2.addChild(SoytreeUtils.cloneWithNewIds(object2));
            }
            builder.add((Object)templateNode2);
        }
        ImmutableList immutableList = builder.build();
        this.templatesByName.put(string2, (List<TemplateNode>)immutableList);
        return immutableList;
    }

    public void foldIntoParent() {
        this.parent.idToEscapingModes.putAll(this.idToEscapingModes);
        this.parent.templateNameToEndContext.putAll(this.templateNameToEndContext);
        this.parent.callIdToDerivedCalleeName.putAll(this.callIdToDerivedCalleeName);
        this.parent.templatesByName.putAll(this.templatesByName);
        this.parent.templatesChecked.addAll(this.templatesChecked);
    }

    public List<TemplateNode> getAllTemplates() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<TemplateNode> list : this.templatesByName.values()) {
            builder.addAll(list);
        }
        return builder.build();
    }

    public void recordTemplateChecked(String string) {
        this.templatesChecked.add(string);
    }

    public boolean wasTemplateChecked(String string) {
        return this.templatesChecked.contains(string);
    }

    public IdGenerator getIdGenerator() {
        return this.idGen;
    }
}

