/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.parsepasses.contextautoesc.EscapingMode;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.RawTextContextUpdater;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeExceptionWrapper;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class InferenceEngine {
    private final AutoescapeMode autoescapeMode;
    private final Inferences inferences;
    @Nullable
    private final EscapingMode defaultEscapingMode;

    public static Context inferTemplateEndContext(TemplateNode templateNode, Context context, Inferences inferences) throws SoyAutoescapeException {
        Context context2;
        try {
            Context context3 = context;
            AutoescapeMode autoescapeMode = templateNode.getAutoescapeMode();
            for (SoyNode.StandaloneNode standaloneNode : templateNode.getChildren()) {
                context3 = new InferenceEngine(autoescapeMode, inferences).infer(standaloneNode, context3);
            }
            context2 = context3;
            inferences.recordTemplateEndContext(templateNode.getTemplateName(), context2);
        }
        catch (SoyAutoescapeExceptionWrapper soyAutoescapeExceptionWrapper) {
            SoyFileNode soyFileNode;
            SoyAutoescapeException soyAutoescapeException = soyAutoescapeExceptionWrapper.getSoyAutoescapeException();
            if (soyAutoescapeException.getTemplateName() == null) {
                soyAutoescapeException.setTemplateName(templateNode.getTemplateNameForUserMsgs());
            }
            if (!soyAutoescapeException.getSourceLocation().isKnown() && (soyFileNode = templateNode.getNearestAncestor(SoyFileNode.class)) != null) {
                soyAutoescapeException.setFilePath(soyFileNode.getFilePath());
            }
            throw soyAutoescapeException;
        }
        return context2;
    }

    private InferenceEngine(AutoescapeMode autoescapeMode, Inferences inferences) {
        this.autoescapeMode = autoescapeMode;
        this.inferences = inferences;
        this.defaultEscapingMode = autoescapeMode != AutoescapeMode.FALSE ? EscapingMode.ESCAPE_HTML : null;
    }

    private Context infer(SoyNode soyNode, Context context) {
        return new ContextPropagatingVisitor(context).exec(soyNode);
    }

    private final class ContextPropagatingVisitor
    extends AbstractSoyNodeVisitor<Context> {
        private Context context;

        public ContextPropagatingVisitor(Context context) {
            this.context = context;
        }

        @Override
        public Context exec(SoyNode soyNode) {
            this.visit(soyNode);
            return this.context;
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
            Context context;
            String string = rawTextNode.getRawText();
            try {
                context = RawTextContextUpdater.processRawText(string, this.context);
            }
            catch (SoyAutoescapeException soyAutoescapeException) {
                soyAutoescapeException.maybeSetContextNode(rawTextNode);
                throw new SoyAutoescapeExceptionWrapper(soyAutoescapeException);
            }
            if (context.isErrorContext()) {
                throw new SoyAutoescapeExceptionWrapper(new SoyAutoescapeException(rawTextNode, "Failed to compute an output context for raw text `" + string + "` starting in context " + this.context));
            }
            this.context = context;
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            try {
                String string = callNode instanceof CallBasicNode ? ((CallBasicNode)callNode).getCalleeName() : ((CallDelegateNode)callNode).getDelCalleeName();
                Pair<String, Context> pair = this.inferCallSite(this.context, string, InferenceEngine.this.inferences);
                String string2 = (String)pair.first;
                if (!string.equals(string2)) {
                    InferenceEngine.this.inferences.retargetCall(callNode, string2);
                }
                this.context = (Context)pair.second;
            }
            catch (SoyAutoescapeException soyAutoescapeException) {
                soyAutoescapeException.maybeSetContextNode(callNode);
                throw new SoyAutoescapeExceptionWrapper(soyAutoescapeException);
            }
        }

        /*
         * WARNING - void declaration
         */
        private Pair<String, Context> inferCallSite(Context context, String string, Inferences inferences) throws SoyAutoescapeException {
            inferences.recordTemplateChecked(string);
            List<TemplateNode> list = inferences.lookupTemplates(string);
            if (list == null || list.isEmpty()) {
                return Pair.of(string, context);
            }
            String string2 = DerivedTemplateUtils.getSuffix(context);
            String string3 = DerivedTemplateUtils.getBaseName(string);
            String string4 = string3 + string2;
            Context context2 = inferences.getTemplateEndContext(string4);
            if (context2 != null) {
                return Pair.of(string4, context2);
            }
            List<TemplateNode> list2 = inferences.lookupTemplates(string4);
            if (list2 == null) {
                list2 = inferences.cloneTemplates(string3, string4);
            }
            Inferences inferences2 = new Inferences(inferences);
            inferences2.recordTemplateEndContext(string4, context);
            for (TemplateNode object : list2) {
                Context context3 = InferenceEngine.inferTemplateEndContext(object, context, inferences2);
                context2 = context2 != null ? Context.union(context2, context3) : context3;
            }
            if (!context2.equals(context) && inferences2.wasTemplateChecked(string4)) {
                void var12_14;
                Inferences inferences3 = new Inferences(inferences);
                inferences3.recordTemplateEndContext(string4, context2);
                Object var12_13 = null;
                for (TemplateNode templateNode : list2) {
                    Context context4 = InferenceEngine.inferTemplateEndContext(templateNode, context, inferences3);
                    Context context5 = var12_14 != null ? Context.union(context4, (Context)var12_14) : context4;
                }
                if ((context2 = Context.union((Context)var12_14, context2)).isErrorContext()) {
                    throw new SoyAutoescapeException(list2.get(0), "Cannot determine end context for recursive template " + string);
                }
            }
            inferences2.recordTemplateEndContext(string4, context2);
            inferences2.foldIntoParent();
            return Pair.of(string4, context2);
        }

        @Override
        protected void visitIfNode(IfNode ifNode) {
            this.propagateAcrossDisjunction(ifNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode switchNode) {
            this.propagateAcrossDisjunction(switchNode);
        }

        private void propagateAcrossDisjunction(SoyNode.ParentSoyNode<?> parentSoyNode) {
            try {
                Object object;
                Iterator iterator = parentSoyNode.getChildren().iterator();
                SoyNode soyNode = (SoyNode)iterator.next();
                Object object2 = InferenceEngine.this.infer(soyNode, this.context);
                boolean bl = false;
                while (iterator.hasNext()) {
                    object = (SoyNode)iterator.next();
                    Context context = InferenceEngine.this.infer((SoyNode)object, this.context);
                    Context context2 = Context.union((Context)object2, context);
                    if (context2.isErrorContext()) {
                        throw new SoyAutoescapeException((SoyNode)object, (parentSoyNode instanceof IfNode ? "{if} command branch ends in a different context than preceding branches: " : "{switch} command case ends in a different context than preceding cases: ") + object.toSourceString());
                    }
                    object2 = context2;
                    if (!(object instanceof IfElseNode) && !(object instanceof SwitchDefaultNode)) continue;
                    bl = true;
                }
                if (!bl) {
                    object = Context.union(this.context, (Context)object2);
                    if (((Context)object).isErrorContext()) {
                        throw new SoyAutoescapeException(parentSoyNode, (parentSoyNode instanceof IfNode ? "{if} command without {else} changes context : " : "{switch} command without {default} changes context : ") + parentSoyNode.toSourceString());
                    }
                    object2 = object;
                }
                this.context = object2;
            }
            catch (SoyAutoescapeException soyAutoescapeException) {
                soyAutoescapeException.maybeSetContextNode(parentSoyNode);
                throw new SoyAutoescapeExceptionWrapper(soyAutoescapeException);
            }
        }

        @Override
        protected void visitForNode(ForNode forNode) {
            try {
                Context context = this.context;
                for (SoyNode.StandaloneNode standaloneNode : forNode.getChildren()) {
                    context = InferenceEngine.this.infer(standaloneNode, context);
                }
                Context context2 = Context.union(this.context, context);
                if (context2.isErrorContext()) {
                    throw new SoyAutoescapeException(forNode, "{for} command changes context so it cannot be reentered : " + forNode.toSourceString());
                }
                this.context = context2;
            }
            catch (SoyAutoescapeException soyAutoescapeException) {
                soyAutoescapeException.maybeSetContextNode(forNode);
                throw new SoyAutoescapeExceptionWrapper(soyAutoescapeException);
            }
        }

        @Override
        protected void visitForeachNode(ForeachNode foreachNode) {
            ForeachIfemptyNode foreachIfemptyNode;
            List list = foreachNode.getChildren();
            ForeachNonemptyNode foreachNonemptyNode = (ForeachNonemptyNode)list.get(0);
            if (list.size() == 2) {
                foreachIfemptyNode = (ForeachIfemptyNode)list.get(1);
            } else if (list.size() == 1) {
                foreachIfemptyNode = null;
            } else {
                throw new AssertionError();
            }
            try {
                Context context;
                Context context2;
                Context context3 = this.context;
                if (foreachNonemptyNode != null) {
                    context3 = InferenceEngine.this.infer(foreachNonemptyNode, this.context);
                    context2 = InferenceEngine.this.infer(foreachNonemptyNode, context3);
                    context = Context.union(context2, context3);
                    if (context.isErrorContext()) {
                        throw new SoyAutoescapeException(foreachNonemptyNode, "{foreach} body does not end in the same context after repeated entries : " + foreachNonemptyNode.toSourceString());
                    }
                    context3 = context;
                }
                if ((context = Context.union(context2 = foreachIfemptyNode != null ? InferenceEngine.this.infer(foreachIfemptyNode, this.context) : this.context, context3)).isErrorContext()) {
                    throw new SoyAutoescapeException(foreachIfemptyNode == null ? foreachNode : foreachIfemptyNode, (foreachIfemptyNode == null ? "{foreach} body changes context : " : "{foreach} body does not end in the same context as {ifempty} : ") + foreachNode.toSourceString());
                }
                this.context = context;
            }
            catch (SoyAutoescapeException soyAutoescapeException) {
                soyAutoescapeException.maybeSetContextNode(foreachNode);
                throw new SoyAutoescapeExceptionWrapper(soyAutoescapeException);
            }
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            try {
                ImmutableList immutableList = InferenceEngine.this.inferences.getEscapingMode(printNode);
                this.context = this.context.getContextBeforeDynamicValue();
                if (immutableList.isEmpty()) {
                    switch (InferenceEngine.this.autoescapeMode) {
                        case CONTEXTUAL: {
                            immutableList = this.context.getEscapingModes();
                            InferenceEngine.this.inferences.setEscapingDirectives(printNode, (List<EscapingMode>)immutableList);
                            break;
                        }
                        case FALSE: {
                            break;
                        }
                        case TRUE: {
                            immutableList = ImmutableList.of((Object)((Object)InferenceEngine.this.defaultEscapingMode));
                        }
                    }
                } else if (!this.context.isCompatibleWith((EscapingMode)((Object)immutableList.get(0)))) {
                    throw new SoyAutoescapeException(printNode, "Escaping modes " + immutableList + " not compatible with " + this.context + " : " + printNode.toSourceString());
                }
                if (!immutableList.isEmpty() || InferenceEngine.this.autoescapeMode == AutoescapeMode.CONTEXTUAL) {
                    Context context = this.context.getContextAfterEscaping(immutableList.isEmpty() ? null : (EscapingMode)((Object)immutableList.get(0)));
                    if (context.isErrorContext()) {
                        if (this.context.uriPart == Context.UriPart.UNKNOWN || this.context.uriPart == Context.UriPart.UNKNOWN_PRE_FRAGMENT) {
                            throw new SoyAutoescapeException(printNode, "Cannot determine which part of the URL " + printNode.toSourceString() + " is in.");
                        }
                        throw new SoyAutoescapeException(printNode, "Don't put {print} inside comments : " + printNode.toSourceString());
                    }
                    this.context = context;
                } else {
                    this.context = RawTextContextUpdater.processRawText("z", this.context);
                }
            }
            catch (SoyAutoescapeException soyAutoescapeException) {
                soyAutoescapeException.maybeSetContextNode(printNode);
                throw new SoyAutoescapeExceptionWrapper(soyAutoescapeException);
            }
        }

        @Override
        protected void visitCssNode(CssNode cssNode) {
            this.context = this.context.getContextBeforeDynamicValue();
        }

        @Override
        protected void visitSoyNode(SoyNode soyNode) {
            if (soyNode instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)soyNode);
            }
        }
    }
}

