/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.InferenceEngine;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.Rewriter;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.parsepasses.contextautoesc.TemplateCallGraph;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ContextualAutoescaper {
    private final ImmutableSet<String> soyEscapingDirectives;
    private final Map<String, SanitizedContent.ContentKind> sanitizedContentOperators;
    private Inferences inferences;
    private static final Predicate<TemplateNode> IS_CONTEXTUAL = new Predicate<TemplateNode>(){

        public boolean apply(TemplateNode templateNode) {
            return templateNode.getAutoescapeMode() == AutoescapeMode.CONTEXTUAL;
        }
    };
    private static final Predicate<TemplateNode> IS_PUBLIC_CONTEXTUAL = new Predicate<TemplateNode>(){

        public boolean apply(TemplateNode templateNode) {
            return templateNode.getAutoescapeMode() == AutoescapeMode.CONTEXTUAL && !templateNode.isPrivate();
        }
    };

    @Inject
    ContextualAutoescaper(final Map<String, SoyPrintDirective> map) {
        this((Iterable<? extends String>)ImmutableSet.copyOf((Collection)Collections2.filter(map.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return ((SoyPrintDirective)map.get(string)).shouldCancelAutoescape();
            }
        })), ContextualAutoescaper.makeOperatorKindMap(map));
    }

    public ContextualAutoescaper(Iterable<? extends String> iterable, Map<? extends String, ? extends SanitizedContent.ContentKind> map) {
        this.soyEscapingDirectives = ImmutableSet.copyOf(iterable);
        this.sanitizedContentOperators = ImmutableMap.copyOf(map);
    }

    public List<TemplateNode> rewrite(SoyFileSetNode soyFileSetNode) throws SoyAutoescapeException {
        ImmutableList immutableList = ImmutableList.copyOf(soyFileSetNode.getChildren());
        Map<String, ImmutableList<TemplateNode>> map = ContextualAutoescaper.findTemplates((Iterable<? extends SoyFileNode>)immutableList);
        Inferences inferences = new Inferences((Set<String>)this.soyEscapingDirectives, soyFileSetNode.getNodeIdGenerator(), map);
        List<TemplateNode> list = inferences.getAllTemplates();
        TemplateCallGraph templateCallGraph = new TemplateCallGraph(map);
        Set<TemplateNode> set = templateCallGraph.callersOf(Collections2.filter(list, IS_CONTEXTUAL));
        set.addAll(Collections2.filter(list, IS_PUBLIC_CONTEXTUAL));
        for (TemplateNode templateNode : set) {
            InferenceEngine.inferTemplateEndContext(templateNode, Context.HTML_PCDATA, inferences);
        }
        this.inferences = inferences;
        return new Rewriter(inferences, this.sanitizedContentOperators).rewrite(soyFileSetNode);
    }

    public Context getTemplateEndContext(String string) {
        return this.inferences.getTemplateEndContext(string);
    }

    private static Map<String, ImmutableList<TemplateNode>> findTemplates(Iterable<? extends SoyFileNode> iterable) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (SoyFileNode object : iterable) {
            for (TemplateNode templateNode : object.getChildren()) {
                String string = templateNode instanceof TemplateBasicNode ? templateNode.getTemplateName() : ((TemplateDelegateNode)templateNode).getDelTemplateName();
                if (!linkedHashMap.containsKey(string)) {
                    linkedHashMap.put(string, ImmutableList.builder());
                }
                ((ImmutableList.Builder)linkedHashMap.get(string)).add((Object)templateNode);
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            builder.put(entry.getKey(), (Object)((ImmutableList.Builder)entry.getValue()).build());
        }
        return builder.build();
    }

    private static Map<String, SanitizedContent.ContentKind> makeOperatorKindMap(Map<String, SoyPrintDirective> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SoyPrintDirective soyPrintDirective : map.values()) {
            if (!(soyPrintDirective instanceof SanitizedContentOperator)) continue;
            builder.put((Object)soyPrintDirective.getName(), (Object)((SanitizedContentOperator)((Object)soyPrintDirective)).getContentKind());
        }
        return builder.build();
    }
}

