/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;

public class RewriteRemainderNodesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private MsgPluralNode currPluralNode;

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        FunctionNode functionNode;
        ExprRootNode<?> exprRootNode = printNode.getExprUnion().getExpr();
        if (exprRootNode == null) {
            return;
        }
        if (exprRootNode.getChild(0) instanceof FunctionNode && (functionNode = (FunctionNode)exprRootNode.getChild(0)).getFunctionName().equals("remainder")) {
            if (this.currPluralNode == null) {
                throw new SoySyntaxException("The special function 'remainder' is for use in plural messages (tag " + printNode.toSourceString() + ").");
            }
            if (functionNode.numChildren() != 1) {
                throw new SoySyntaxException("The function 'remainder' has to have exactly one argument (tag " + printNode.toSourceString() + ").");
            }
            if (!functionNode.getChild(0).toSourceString().equals(this.currPluralNode.getExpr().toSourceString())) {
                throw new SoySyntaxException("The parameter to 'remainder' has to be the same as the 'plural' variable (tag " + printNode.toSourceString() + ").");
            }
            if (this.currPluralNode.getOffset() == 0) {
                throw new SoySyntaxException("In 'plural' block, use of 'remainder' function is unnecessary since offset = 0 (tag " + printNode.toSourceString() + ").");
            }
            if (printNode.getUserSuppliedPlaceholderName() != null) {
                throw new SoySyntaxException("Cannot use special function 'remainder' and attribute 'phname' together (tag " + printNode.toSourceString() + ").");
            }
            String string = "(" + this.currPluralNode.getExpr().toSourceString() + ") - " + this.currPluralNode.getOffset();
            PrintNode printNode2 = new PrintNode(printNode.getId(), printNode.isImplicit(), string, null);
            printNode2.addChildren(printNode.getChildren());
            printNode.getParent().replaceChild(printNode, printNode2);
        }
    }

    @Override
    protected void visitMsgPluralNode(MsgPluralNode msgPluralNode) {
        this.currPluralNode = msgPluralNode;
        this.visitChildren(msgPluralNode);
        this.currPluralNode = null;
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

