/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import java.util.List;

public class HandleCssCommandVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyGeneralOptions.CssHandlingScheme cssHandlingScheme;
    private List<CssNode> cssNodes;

    public HandleCssCommandVisitor(SoyGeneralOptions.CssHandlingScheme cssHandlingScheme) {
        this.cssHandlingScheme = cssHandlingScheme;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        this.cssNodes = Lists.newArrayList();
        this.visit(soyNode);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        if (this.cssHandlingScheme == SoyGeneralOptions.CssHandlingScheme.BACKEND_SPECIFIC) {
            return;
        }
        this.visitChildren(soyFileSetNode);
        IdGenerator idGenerator = soyFileSetNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        for (CssNode cssNode : this.cssNodes) {
            AbstractSoyNode abstractSoyNode;
            if (this.cssHandlingScheme == SoyGeneralOptions.CssHandlingScheme.LITERAL) {
                abstractSoyNode = new RawTextNode(idGenerator.genId(), cssNode.getCommandText());
            } else if (this.cssHandlingScheme == SoyGeneralOptions.CssHandlingScheme.REFERENCE) {
                PrintNode printNode = new PrintNode(idGenerator.genId(), false, cssNode.getCommandText(), null);
                printNode.addChild(new PrintDirectiveNode(idGenerator.genId(), "|noAutoescape", ""));
                abstractSoyNode = printNode;
                boolean bl = false;
                if (printNode.getExprUnion().getExpr() == null) {
                    bl = true;
                } else {
                    Node node = printNode.getExprUnion().getExpr().getChild(0);
                    if (!(node instanceof DataRefNode) && !(node instanceof GlobalNode)) {
                        bl = true;
                    }
                }
                if (bl) {
                    throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("The css-handling scheme is 'reference', but tag " + cssNode.getTagString() + " does not contain a valid reference.", null, soyFileSetNode);
                }
            } else {
                throw new AssertionError();
            }
            cssNode.getParent().replaceChild(cssNode, abstractSoyNode);
        }
    }

    @Override
    protected void visitCssNode(CssNode cssNode) {
        this.cssNodes.add(cssNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

