/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.Set;

public class CheckFunctionCallsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final Map<String, SoyFunction> soyFunctionsByName;
    private boolean allowExternallyDefinedFunctions;

    @Inject
    public CheckFunctionCallsVisitor(Map<String, SoyFunction> map) {
        this.soyFunctionsByName = ImmutableMap.copyOf(map);
    }

    public void setAllowExternallyDefinedFunctions(boolean bl) {
        this.allowExternallyDefinedFunctions = bl;
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ExprHolderNode) {
            for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)soyNode).getAllExprUnions()) {
                if (exprUnion.getExpr() == null) continue;
                try {
                    new CheckFunctionCallsExprVisitor((SoyNode.ExprHolderNode)soyNode).exec(exprUnion.getExpr());
                }
                catch (SoySyntaxException soySyntaxException) {
                    SourceLocation sourceLocation = soyNode.getLocation();
                    if (sourceLocation.isKnown() && !soySyntaxException.getSourceLocation().isKnown()) {
                        soySyntaxException.setSourceLocation(sourceLocation);
                    }
                    throw soySyntaxException;
                }
            }
        }
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }

    private final class CheckFunctionCallsExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final SoyNode.ExprHolderNode container;

        CheckFunctionCallsExprVisitor(SoyNode.ExprHolderNode exprHolderNode) {
            this.container = exprHolderNode;
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)exprNode);
            }
        }

        @Override
        protected void visitFunctionNode(FunctionNode functionNode) {
            String string = functionNode.getFunctionName();
            int n = functionNode.numChildren();
            NonpluginFunction nonpluginFunction = NonpluginFunction.forFunctionName(string);
            if (nonpluginFunction != null) {
                if (n != nonpluginFunction.getNumArgs()) {
                    throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
                }
                switch (nonpluginFunction) {
                    case INDEX: 
                    case IS_FIRST: 
                    case IS_LAST: {
                        this.requireLoopVariableInScope(functionNode, functionNode.getChild(0));
                        return;
                    }
                    case HAS_DATA: {
                        return;
                    }
                }
                throw new AssertionError((Object)("Unrecognized nonplugin fn " + (Object)((Object)nonpluginFunction)));
            }
            SoyFunction soyFunction = (SoyFunction)CheckFunctionCallsVisitor.this.soyFunctionsByName.get(string);
            if (soyFunction != null) {
                Set<Integer> set = soyFunction.getValidArgsSizes();
                if (!set.contains(n)) {
                    throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
                }
            } else if (!CheckFunctionCallsVisitor.this.allowExternallyDefinedFunctions) {
                throw new SoySyntaxException("Unrecognized function '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            this.visitChildren(functionNode);
        }

        private void requireLoopVariableInScope(FunctionNode functionNode, ExprNode exprNode) {
            if (!this.isLoopVariableInScope(exprNode)) {
                throw new SoySyntaxException("Error in function call \"" + functionNode.toSourceString() + "\".  It takes a foreach loop variable.");
            }
        }

        private boolean isLoopVariableInScope(ExprNode exprNode) {
            if (!(exprNode instanceof DataRefNode)) {
                return false;
            }
            DataRefNode dataRefNode = (DataRefNode)exprNode;
            if (dataRefNode.isIjDataRef()) {
                return false;
            }
            if (dataRefNode.numChildren() != 1) {
                return false;
            }
            String string = dataRefNode.getFirstKey();
            for (SoyNode.ParentSoyNode<?> parentSoyNode = this.container.getParent(); parentSoyNode != null; parentSoyNode = parentSoyNode.getParent()) {
                String string2;
                if (!(parentSoyNode instanceof ForeachNonemptyNode) || !string.equals(string2 = ((ForeachNonemptyNode)parentSoyNode).getVarName())) continue;
                return true;
            }
            return false;
        }
    }
}

