/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CheckDelegatesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private TemplateRegistry templateRegistry;
    private String currTemplateNameForUserMsgs;
    private String currDelPackageName;

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)(soyNode instanceof SoyFileSetNode));
        this.templateRegistry = new TemplateRegistry((SoyFileSetNode)soyNode);
        this.checkTemplates();
        super.exec(soyNode);
        return null;
    }

    private void checkTemplates() {
        Map<String, TemplateBasicNode> map = this.templateRegistry.getBasicTemplatesMap();
        Map<String, List<TemplateRegistry.DelegateTemplateDivision>> map2 = this.templateRegistry.getDelegateTemplatesMap();
        Sets.SetView setView = Sets.intersection(map.keySet(), map2.keySet());
        if (setView.size() > 0) {
            throw new SoySyntaxException(String.format("Found template name %s being reused for both basic and delegate templates.", setView));
        }
        for (List<TemplateRegistry.DelegateTemplateDivision> object : map2.values()) {
            TemplateDelegateNode templateDelegateNode = null;
            HashSet hashSet = null;
            for (TemplateRegistry.DelegateTemplateDivision delegateTemplateDivision : object) {
                for (TemplateDelegateNode templateDelegateNode2 : delegateTemplateDivision.delPackageNameToDelTemplateMap.values()) {
                    if (templateDelegateNode == null) {
                        templateDelegateNode = templateDelegateNode2;
                        hashSet = Sets.newHashSet(templateDelegateNode2.getSoyDocParams());
                        continue;
                    }
                    HashSet hashSet2 = Sets.newHashSet(templateDelegateNode2.getSoyDocParams());
                    if (((Object)hashSet2).equals(hashSet)) continue;
                    String string = templateDelegateNode.getDelPackageName() != null ? templateDelegateNode.getDelPackageName() : "none";
                    String string2 = templateDelegateNode2.getDelPackageName() != null ? templateDelegateNode2.getDelPackageName() : "none";
                    throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("Found delegate templates with same name '%s' but different param declarations in delegate packages '%s' and '%s'.", templateDelegateNode.getDelTemplateName(), string, string2), null, templateDelegateNode);
                }
            }
        }
        for (TemplateBasicNode templateBasicNode : map.values()) {
            if (templateBasicNode.getDelPackageName() == null || templateBasicNode.isPrivate()) continue;
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("Found public template '%s' in delegate package '%s' (must mark as private).", templateBasicNode.getTemplateName(), templateBasicNode.getDelPackageName()), null, templateBasicNode);
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        this.currTemplateNameForUserMsgs = templateNode.getTemplateNameForUserMsgs();
        this.currDelPackageName = templateNode.getDelPackageName();
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode callBasicNode) {
        String string;
        String string2 = callBasicNode.getCalleeName();
        if (this.templateRegistry.getSortedDelegateTemplateDivisions(string2) != null) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("In template '%s', found a 'call' referencing a delegate template '%s' (expected 'delcall').", this.currTemplateNameForUserMsgs, string2), null, callBasicNode);
        }
        TemplateBasicNode templateBasicNode = this.templateRegistry.getBasicTemplate(string2);
        if (templateBasicNode != null && (string = templateBasicNode.getDelPackageName()) != null && !string.equals(this.currDelPackageName)) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("Found illegal call from '%s' to '%s', which is in a different delegate package.", this.currTemplateNameForUserMsgs, templateBasicNode.getTemplateName()), null, callBasicNode);
        }
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode callDelegateNode) {
        String string = callDelegateNode.getDelCalleeName();
        if (this.templateRegistry.getBasicTemplate(string) != null) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo(String.format("In template '%s', found a 'delcall' referencing a basic template '%s' (expected 'call').", this.currTemplateNameForUserMsgs, string), null, callDelegateNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

