/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;

public class SoyTemplateInfo {
    private final String name;
    private final String partialName;
    private final ImmutableMap<String, ParamRequisiteness> paramsMap;
    private final ImmutableSortedSet<String> usedIjParams;

    public SoyTemplateInfo(String string, ImmutableMap<String, ParamRequisiteness> immutableMap) {
        this(string, immutableMap, (ImmutableSortedSet<String>)ImmutableSortedSet.of());
    }

    public SoyTemplateInfo(String string, ImmutableMap<String, ParamRequisiteness> immutableMap, ImmutableSortedSet<String> immutableSortedSet) {
        this.name = string;
        int n = string.lastIndexOf(46);
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        this.partialName = string.substring(n);
        this.paramsMap = immutableMap;
        this.usedIjParams = immutableSortedSet;
    }

    public String getName() {
        return this.name;
    }

    public String getPartialName() {
        return this.partialName;
    }

    public ImmutableMap<String, ParamRequisiteness> getParams() {
        return this.paramsMap;
    }

    public ImmutableSortedSet<String> getUsedIjParams() {
        return this.usedIjParams;
    }

    public static enum ParamRequisiteness {
        REQUIRED,
        OPTIONAL;

    }
}

