/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.template.soy.msgs.SoyMsgException;
import java.util.Locale;

public class SoyMsgPluralCaseSpec {
    private final Type type;
    private final int explicitValue;
    private final String stringRepresentation;

    public SoyMsgPluralCaseSpec(String string) {
        this.type = Type.valueOf(string.toUpperCase(Locale.ENGLISH));
        this.explicitValue = -1;
        this.stringRepresentation = string.toLowerCase(Locale.ENGLISH);
    }

    public SoyMsgPluralCaseSpec(int n) {
        if (n < 0) {
            throw new SoyMsgException("Negative plural case value.");
        }
        this.type = Type.EXPLICIT;
        this.explicitValue = n;
        this.stringRepresentation = "=" + n;
    }

    public Type getType() {
        return this.type;
    }

    public int getExplicitValue() {
        return this.explicitValue;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public static enum Type {
        EXPLICIT,
        ZERO,
        ONE,
        TWO,
        FEW,
        MANY,
        OTHER;

    }
}

