/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public class InsertMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyMsgBundle msgBundle;
    private final boolean dontErrorOnPluralSelectMsgs;
    private IdGenerator nodeIdGen;
    private List<SoyNode.StandaloneNode> currMsgReplacementNodes;

    public InsertMsgsVisitor(@Nullable SoyMsgBundle soyMsgBundle, boolean bl) {
        this.msgBundle = soyMsgBundle;
        this.dontErrorOnPluralSelectMsgs = bl;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        this.nodeIdGen = soyNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        super.exec(soyNode);
        return null;
    }

    @Override
    protected void visitMsgNode(MsgNode msgNode) {
        SoyMsg soyMsg;
        if (msgNode.numChildren() == 1 && (msgNode.getChild(0) instanceof MsgSelectNode || msgNode.getChild(0) instanceof MsgPluralNode)) {
            if (this.dontErrorOnPluralSelectMsgs) {
                return;
            }
            throw new EncounteredPluralSelectMsgException();
        }
        this.currMsgReplacementNodes = Lists.newArrayList();
        long l = MsgUtils.computeMsgId(msgNode);
        SoyMsg soyMsg2 = soyMsg = this.msgBundle == null ? null : this.msgBundle.getMsg(l);
        if (soyMsg != null) {
            for (SoyMsgPart object : soyMsg.getParts()) {
                String string;
                if (object instanceof SoyMsgRawTextPart) {
                    string = ((SoyMsgRawTextPart)object).getRawText();
                    this.currMsgReplacementNodes.add(new RawTextNode(this.nodeIdGen.genId(), string));
                    continue;
                }
                if (object instanceof SoyMsgPlaceholderPart) {
                    string = ((SoyMsgPlaceholderPart)object).getPlaceholderName();
                    MsgPlaceholderNode msgPlaceholderNode = msgNode.getRepPlaceholderNode(string);
                    for (SoyNode.StandaloneNode standaloneNode : msgPlaceholderNode.getChildren()) {
                        if (standaloneNode instanceof MsgHtmlTagNode) {
                            this.visit(standaloneNode);
                            continue;
                        }
                        this.currMsgReplacementNodes.add(standaloneNode);
                    }
                    continue;
                }
                throw new AssertionError();
            }
        } else {
            for (SoyNode.StandaloneNode n : msgNode.getChildren()) {
                if (n instanceof RawTextNode) {
                    this.currMsgReplacementNodes.add(n);
                    continue;
                }
                if (n instanceof MsgPlaceholderNode) {
                    for (SoyNode.StandaloneNode standaloneNode : ((MsgPlaceholderNode)n).getChildren()) {
                        if (standaloneNode instanceof MsgHtmlTagNode) {
                            this.visit(standaloneNode);
                            continue;
                        }
                        this.currMsgReplacementNodes.add(standaloneNode);
                    }
                    continue;
                }
                throw new AssertionError();
            }
        }
        SoyNode.BlockNode blockNode = msgNode.getParent();
        int n = blockNode.getChildIndex(msgNode);
        blockNode.removeChild(n);
        blockNode.addChildren(n, this.currMsgReplacementNodes);
        this.currMsgReplacementNodes = null;
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        for (SoyNode.StandaloneNode standaloneNode : msgHtmlTagNode.getChildren()) {
            this.currMsgReplacementNodes.add(standaloneNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)soyNode);
        }
    }

    public static class EncounteredPluralSelectMsgException
    extends RuntimeException {
    }
}

