/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import java.util.List;

class ReplaceMsgsWithGoogMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyJsSrcOptions jsSrcOptions;
    private List<MsgNode> msgNodes;

    @Inject
    public ReplaceMsgsWithGoogMsgsVisitor(SoyJsSrcOptions soyJsSrcOptions) {
        this.jsSrcOptions = soyJsSrcOptions;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        this.msgNodes = Lists.newArrayList();
        this.visit(soyNode);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
        IdGenerator idGenerator = soyFileSetNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        for (MsgNode msgNode : this.msgNodes) {
            this.replaceMsgNodeHelper(msgNode, idGenerator);
        }
    }

    @Override
    protected void visitMsgNode(MsgNode msgNode) {
        this.msgNodes.add(msgNode);
        this.visitChildren(msgNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }

    private void replaceMsgNodeHelper(MsgNode msgNode, IdGenerator idGenerator) {
        int n = idGenerator.genId();
        String string = this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgId(msgNode) : "MSG_UNNAMED_" + n;
        GoogMsgNode googMsgNode = new GoogMsgNode(n, msgNode, string);
        GoogMsgRefNode googMsgRefNode = new GoogMsgRefNode(idGenerator.genId(), googMsgNode.getRenderedGoogMsgVarName());
        SoyNode.BlockNode blockNode = msgNode.getParent();
        int n2 = blockNode.getChildIndex(msgNode);
        blockNode.replaceChild(n2, googMsgNode);
        blockNode.addChild(n2 + 1, googMsgRefNode);
    }
}

