/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import java.util.Map;

@ApiCallScope
class IsComputableAsJsExprsVisitor
extends AbstractReturningSoyNodeVisitor<Boolean> {
    private final SoyJsSrcOptions jsSrcOptions;
    private final Map<SoyNode, Boolean> memoizedResults;

    @Inject
    IsComputableAsJsExprsVisitor(SoyJsSrcOptions soyJsSrcOptions) {
        this.jsSrcOptions = soyJsSrcOptions;
        this.memoizedResults = Maps.newHashMap();
    }

    @Override
    protected Boolean visit(SoyNode soyNode) {
        if (this.memoizedResults.containsKey(soyNode)) {
            return this.memoizedResults.get(soyNode);
        }
        Boolean bl = (Boolean)super.visit(soyNode);
        this.memoizedResults.put(soyNode, bl);
        return bl;
    }

    @Override
    protected Boolean visitTemplateNode(TemplateNode templateNode) {
        return this.areChildrenComputableAsJsExprs(templateNode);
    }

    @Override
    protected Boolean visitRawTextNode(RawTextNode rawTextNode) {
        return true;
    }

    @Override
    protected Boolean visitGoogMsgNode(GoogMsgNode googMsgNode) {
        return false;
    }

    @Override
    protected Boolean visitMsgPlaceholderNode(MsgPlaceholderNode msgPlaceholderNode) {
        return this.areChildrenComputableAsJsExprs(msgPlaceholderNode);
    }

    @Override
    protected Boolean visitGoogMsgRefNode(GoogMsgRefNode googMsgRefNode) {
        return true;
    }

    @Override
    protected Boolean visitMsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        return this.areChildrenComputableAsJsExprs(msgHtmlTagNode);
    }

    @Override
    protected Boolean visitPrintNode(PrintNode printNode) {
        return true;
    }

    @Override
    protected Boolean visitCssNode(CssNode cssNode) {
        return true;
    }

    @Override
    protected Boolean visitLetNode(LetNode letNode) {
        return false;
    }

    @Override
    protected Boolean visitIfNode(IfNode ifNode) {
        return this.areChildrenComputableAsJsExprs(ifNode);
    }

    @Override
    protected Boolean visitIfCondNode(IfCondNode ifCondNode) {
        return this.areChildrenComputableAsJsExprs(ifCondNode);
    }

    @Override
    protected Boolean visitIfElseNode(IfElseNode ifElseNode) {
        return this.areChildrenComputableAsJsExprs(ifElseNode);
    }

    @Override
    protected Boolean visitSwitchNode(SwitchNode switchNode) {
        return false;
    }

    @Override
    protected Boolean visitForeachNode(ForeachNode foreachNode) {
        return false;
    }

    @Override
    protected Boolean visitForNode(ForNode forNode) {
        return false;
    }

    @Override
    protected Boolean visitCallNode(CallNode callNode) {
        return this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.CONCAT && this.areChildrenComputableAsJsExprs(callNode);
    }

    @Override
    protected Boolean visitCallParamValueNode(CallParamValueNode callParamValueNode) {
        return true;
    }

    @Override
    protected Boolean visitCallParamContentNode(CallParamContentNode callParamContentNode) {
        return this.areChildrenComputableAsJsExprs(callParamContentNode);
    }

    private boolean areChildrenComputableAsJsExprs(SoyNode.ParentSoyNode<?> parentSoyNode) {
        for (SoyNode soyNode : parentSoyNode.getChildren()) {
            if (soyNode instanceof RawTextNode || soyNode instanceof PrintNode || this.visit(soyNode).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

