/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.template.soy.shared.restricted.EscapingConventions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.tools.ant.Task;

@ParametersAreNonnullByDefault
public final class GenerateSoyUtilsEscapingDirectiveCode
extends Task {
    private List<FileRef> inputs = Lists.newArrayList();
    private FileRef output;
    private Predicate<String> availableJavaScript = new Predicate<String>(){

        public boolean apply(String string) {
            return string.indexOf(46) < 0;
        }
    };
    static final String GENERATED_CODE_START_MARKER = "// START GENERATED CODE FOR ESCAPERS.";
    static final String GENERATED_CODE_END_MARKER = "// END GENERATED CODE";
    private static final Pattern NAMED_CLASS = Pattern.compile("(?<!\\\\)(\\\\{2})*\\\\p\\{");

    public Predicate<String> getAvailableJavaScript() {
        return this.availableJavaScript;
    }

    public FileRef createInput() {
        FileRef fileRef = new FileRef(true);
        this.inputs.add(fileRef);
        return fileRef;
    }

    public FileRef createOutput() {
        if (this.output != null) {
            throw new IllegalStateException("Too many <output>s");
        }
        this.output = new FileRef(false);
        return this.output;
    }

    public void addConfiguredJsdefined(FunctionNamePredicate functionNamePredicate) {
        final Pattern pattern = functionNamePredicate.namePattern;
        if (pattern == null) {
            throw new IllegalStateException("Please specify a pattern attribute for <jsdefined>");
        }
        this.availableJavaScript = Predicates.or(this.availableJavaScript, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return pattern.matcher(string).matches();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        super.execute();
        if (this.output == null) {
            System.err.println("Please add an <output> for the <" + this.getTaskName() + "> at " + this.getLocation());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (FileRef fileRef : this.inputs) {
            try {
                boolean bl = false;
                for (String string : Files.readLines((File)fileRef.file, (Charset)Charsets.UTF_8)) {
                    if (bl) {
                        if (!GENERATED_CODE_END_MARKER.equals(string.trim())) continue;
                        bl = false;
                        continue;
                    }
                    if (GENERATED_CODE_START_MARKER.equals(string.trim())) {
                        bl = true;
                        continue;
                    }
                    stringBuilder.append(string).append('\n');
                }
                stringBuilder.append('\n');
            }
            catch (IOException iOException) {
                System.err.println("Failed to read " + fileRef.file);
                iOException.printStackTrace();
                return;
            }
        }
        this.generateJavaScript(this.availableJavaScript, stringBuilder);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.output.file), Charsets.UTF_8);
            try {
                ((Writer)outputStreamWriter).append(stringBuilder);
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (IOException iOException) {
            this.output.file.delete();
        }
    }

    @VisibleForTesting
    void generateJavaScript(Predicate<String> predicate, StringBuilder stringBuilder) {
        class DirectiveDigest {
            final String directiveName;
            final int escapesVar;
            final int matcherVar;
            final int filterVar;
            @Nullable
            final String nonAsciiPrefix;

            DirectiveDigest(String string, int n, int n2, @Nullable int n3, String string2) {
                this.directiveName = string;
                this.escapesVar = n;
                this.matcherVar = n2;
                this.filterVar = n3;
                this.nonAsciiPrefix = string2;
            }
        }
        int n;
        String string;
        stringBuilder.append('\n').append(GENERATED_CODE_START_MARKER).append('\n');
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        ArrayList arrayList4 = Lists.newArrayList();
        ArrayList arrayList5 = Lists.newArrayList();
        ArrayList arrayList6 = Lists.newArrayList();
        ArrayList arrayList7 = Lists.newArrayList();
        block0: for (EscapingConventions.CrossLanguageStringXform crossLanguageStringXform : EscapingConventions.getAllEscapers()) {
            int n2;
            Serializable serializable;
            string = crossLanguageStringXform.getDirectiveName().substring(1);
            String string2 = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, string);
            for (String string3 : crossLanguageStringXform.getJsFunctionNames()) {
                if (!predicate.apply((Object)string3)) continue;
                stringBuilder.append('\n').append("/**\n").append(" * @type {function (*) : string}\n").append(" */\n").append("soy.esc.$$").append(string).append("Helper = function(v) {\n").append("  return ").append(string3).append("(String(v));\n").append("};\n");
                continue block0;
            }
            int n3 = -1;
            int n4 = -1;
            if (!crossLanguageStringXform.getEscapes().isEmpty()) {
                Object object2;
                LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
                serializable = new StringBuilder("/[");
                char c = Integer.MIN_VALUE;
                int n5 = Integer.MIN_VALUE;
                for (Object object2 : crossLanguageStringXform.getEscapes()) {
                    char c2 = ((EscapingConventions.Escape)object2).getPlainText();
                    if (c2 == c) {
                        throw new IllegalStateException("Ambiguous escape " + ((EscapingConventions.Escape)object2).getEscaped() + " for " + string);
                    }
                    linkedHashMap.put(Character.valueOf(c2), ((EscapingConventions.Escape)object2).getEscaped());
                    if (c2 != c + '\u0001') {
                        if (n5 != Integer.MIN_VALUE) {
                            GenerateSoyUtilsEscapingDirectiveCode.escapeRegexpRangeOnto((char)n5, c, (StringBuilder)serializable);
                        }
                        n5 = c2;
                    }
                    c = c2;
                }
                if (n5 < 0) {
                    throw new IllegalStateException();
                }
                GenerateSoyUtilsEscapingDirectiveCode.escapeRegexpRangeOnto((char)n5, c, (StringBuilder)serializable);
                ((StringBuilder)serializable).append("]/g");
                int n6 = arrayList.size();
                for (int i = 0; i < n6; ++i) {
                    if (!GenerateSoyUtilsEscapingDirectiveCode.mapsHaveCompatibleOverlap((Map)arrayList.get(i), linkedHashMap)) continue;
                    n3 = i;
                    break;
                }
                if (n3 == -1) {
                    n3 = n6;
                    arrayList.add(linkedHashMap);
                    arrayList2.add(string2);
                } else {
                    ((Map)arrayList.get(n3)).putAll(linkedHashMap);
                    arrayList2.set(n3, (String)arrayList2.get(n3) + "__AND__" + string2);
                }
                object2 = ((StringBuilder)serializable).toString();
                int n7 = arrayList3.indexOf(object2);
                if (n7 < 0) {
                    n2 = arrayList3.size();
                    arrayList3.add(object2);
                    arrayList4.add(string2);
                } else {
                    arrayList4.set(n7, (String)arrayList4.get(n7) + "__AND__" + string2);
                }
            }
            int n8 = -1;
            serializable = crossLanguageStringXform.getValueFilter();
            if (serializable != null) {
                String string4 = GenerateSoyUtilsEscapingDirectiveCode.javaRegexToJs((Pattern)serializable);
                n8 = arrayList5.indexOf(string4);
                if (n8 == -1) {
                    n8 = arrayList5.size();
                    arrayList5.add(string4);
                    arrayList6.add(string2);
                } else {
                    arrayList6.set(n8, (String)arrayList6.get(n8) + "__AND__" + string2);
                }
            }
            arrayList7.add(new DirectiveDigest(string, n3, n2, n8, crossLanguageStringXform.getNonAsciiPrefix()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Map map = (Map)arrayList.get(n);
            string = (String)arrayList2.get(n);
            stringBuilder.append('\n').append("/**\n").append(" * Maps charcters to the escaped versions for the named escape directives.\n").append(" * @type {Object.<string, string>}\n").append(" * @private\n").append(" */\n").append("soy.esc.$$ESCAPE_MAP_FOR_").append(string).append("_ = {");
            boolean bl = false;
            for (Map.Entry entry : map.entrySet()) {
                if (bl) {
                    stringBuilder.append(',');
                }
                stringBuilder.append("\n  ");
                GenerateSoyUtilsEscapingDirectiveCode.writeJsChar(((Character)entry.getKey()).charValue(), stringBuilder);
                stringBuilder.append(": ");
                GenerateSoyUtilsEscapingDirectiveCode.writeJsString((String)entry.getValue(), stringBuilder);
                bl = true;
            }
            stringBuilder.append("\n};\n");
            stringBuilder.append('\n').append("/**\n").append(" * A function that can be used with String.replace..\n").append(" * @param {string} ch A single character matched by a compatible matcher.\n").append(" * @return {string} A token in the output language.\n").append(" * @private\n").append(" */\n").append("soy.esc.$$REPLACER_FOR_").append(string).append("_ = function(ch) {\n").append("  return soy.esc.$$ESCAPE_MAP_FOR_").append(string).append("_[ch];\n").append("};\n");
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            String string5 = (String)arrayList3.get(n);
            string = (String)arrayList4.get(n);
            stringBuilder.append('\n').append("/**\n").append(" * Matches characters that need to be escaped for the named directives.\n").append(" * @type RegExp\n").append(" * @private\n").append(" */\n").append("soy.esc.$$MATCHER_FOR_").append(string).append("_ = ").append(string5).append(";\n");
        }
        for (n = 0; n < arrayList5.size(); ++n) {
            String string6 = (String)arrayList5.get(n);
            string = (String)arrayList6.get(n);
            stringBuilder.append('\n').append("/**\n").append(" * A pattern that vets values produced by the named directives.\n").append(" * @type RegExp\n").append(" * @private\n").append(" */\n").append("soy.esc.$$FILTER_FOR_").append(string).append("_ = ").append(string6).append(";\n");
        }
        for (DirectiveDigest directiveDigest : arrayList7) {
            String string7;
            string = directiveDigest.directiveName;
            stringBuilder.append('\n').append("/**\n").append(" * A helper for the Soy directive |").append(string).append('\n').append(" * @param {*} value Can be of any type but will be coerced to a string.\n").append(" * @return {string} The escaped text.\n").append(" */\n").append("soy.esc.$$").append(string).append("Helper = function(value) {\n").append("  var str = String(value);\n");
            if (directiveDigest.filterVar != -1) {
                string7 = (String)arrayList6.get(directiveDigest.filterVar);
                stringBuilder.append("  if (!soy.esc.$$FILTER_FOR_").append(string7).append("_.test(str)) {\n");
                if (predicate.apply((Object)"goog.asserts.fail")) {
                    stringBuilder.append("    goog.asserts.fail('Bad value `%s` for |").append(string).append("', [str]);\n");
                }
                stringBuilder.append("    return '").append("zSoyz").append("';\n").append("  }\n");
            }
            if (directiveDigest.nonAsciiPrefix != null) {
                throw new UnsupportedOperationException("Non ASCII prefix escapers not implemented yet.");
            }
            if (directiveDigest.escapesVar >= 0) {
                string7 = (String)arrayList2.get(directiveDigest.escapesVar);
                String string8 = (String)arrayList4.get(directiveDigest.matcherVar);
                stringBuilder.append("  return str.replace(\n").append("      soy.esc.$$MATCHER_FOR_").append(string8).append("_,\n").append("      soy.esc.$$REPLACER_FOR_").append(string7).append("_);\n");
            } else {
                stringBuilder.append("  return str;\n");
            }
            stringBuilder.append("};\n");
        }
        stringBuilder.append('\n').append("/**\n").append(" * Matches all tags, HTML comments, and DOCTYPEs in tag soup HTML.\n").append(" *\n").append(" * @type {RegExp}\n").append(" * @private\n").append(" */\n").append("soy.esc.$$HTML_TAG_REGEX_ = ").append(GenerateSoyUtilsEscapingDirectiveCode.javaRegexToJs(EscapingConventions.HTML_TAG_CONTENT)).append("g;\n");
        stringBuilder.append('\n').append(GENERATED_CODE_END_MARKER).append('\n');
    }

    private static <K, V> boolean mapsHaveCompatibleOverlap(Map<K, V> map, Map<K, V> map2) {
        if (map2.size() < map.size()) {
            Map<K, V> map3 = map;
            map = map2;
            map2 = map3;
        }
        boolean bl = false;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v = map2.get(entry.getKey());
            if (v != null) {
                if (!v.equals(entry.getValue())) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (!map2.containsKey(entry.getKey())) continue;
            if (entry.getValue() != null) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private static void writeJsString(String string, StringBuilder stringBuilder) {
        stringBuilder.append('\'').append(EscapingConventions.EscapeJsString.INSTANCE.escape(string)).append('\'');
    }

    private static void writeJsChar(char c, StringBuilder stringBuilder) {
        if (!GenerateSoyUtilsEscapingDirectiveCode.isPrintable(c)) {
            stringBuilder.append(String.format(c >= '\u0100' ? "'\\u%04x'" : "'\\x%02x'", c));
        } else {
            stringBuilder.append('\'').append(EscapingConventions.EscapeJsString.INSTANCE.escape(String.valueOf(c))).append('\'');
        }
    }

    private static void escapeRegexpRangeOnto(char c, char c2, StringBuilder stringBuilder) {
        if (!GenerateSoyUtilsEscapingDirectiveCode.isPrintable(c)) {
            stringBuilder.append(String.format(c >= '\u0100' ? "\\u%04x" : "\\x%02x", c));
        } else {
            stringBuilder.append(EscapingConventions.EscapeJsRegex.INSTANCE.escape(String.valueOf(c)));
        }
        if (c != c2) {
            if (c2 - c > 1) {
                stringBuilder.append('-');
            }
            if (!GenerateSoyUtilsEscapingDirectiveCode.isPrintable(c2)) {
                stringBuilder.append(String.format(c2 >= '\u0100' ? "\\u%04x" : "\\x%02x", c2));
            } else {
                stringBuilder.append(EscapingConventions.EscapeJsRegex.INSTANCE.escape(String.valueOf(c2)));
            }
        }
    }

    private static boolean isPrintable(char c) {
        return ' ' <= c && c <= '~';
    }

    private static String javaRegexToJs(Pattern pattern) {
        String string = pattern.pattern().replace("\r", "\\r").replace("\n", "\\n").replace("\u2028", "\\u2028").replace("\u2029", "\\u2029").replace("\\A", "^").replace("\\z", "$").replaceAll("(?<!\\\\)(?:\\\\{2})*/", "\\\\/");
        if (string.contains("(?<")) {
            throw new IllegalArgumentException("Pattern " + pattern + " uses lookbehind.");
        }
        if ((pattern.flags() & 0x20) != 0) {
            throw new IllegalArgumentException("Pattern " + pattern + " uses DOTALL.");
        }
        if (NAMED_CLASS.matcher(string).find()) {
            throw new IllegalArgumentException("Pattern " + pattern + " uses named characer classes.");
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 4);
        stringBuilder.append('/').append(string).append('/');
        if ((pattern.flags() & 2) != 0) {
            stringBuilder.append('i');
        }
        if ((pattern.flags() & 8) != 0) {
            stringBuilder.append('m');
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        GenerateSoyUtilsEscapingDirectiveCode generateSoyUtilsEscapingDirectiveCode = new GenerateSoyUtilsEscapingDirectiveCode();
        for (String string : stringArray) {
            Object object;
            if (string.startsWith("--input=")) {
                object = generateSoyUtilsEscapingDirectiveCode.createInput();
                ((FileRef)object).setPath(string.substring(string.indexOf(61) + 1));
                continue;
            }
            if (string.startsWith("--output=")) {
                object = generateSoyUtilsEscapingDirectiveCode.createOutput();
                ((FileRef)object).setPath(string.substring(string.indexOf(61) + 1));
                continue;
            }
            if (string.startsWith("--jsdefined=")) {
                object = new FunctionNamePredicate();
                ((FunctionNamePredicate)object).setPattern(string.substring(string.indexOf(61) + 1));
                generateSoyUtilsEscapingDirectiveCode.addConfiguredJsdefined((FunctionNamePredicate)object);
                continue;
            }
            throw new IllegalArgumentException(string);
        }
        generateSoyUtilsEscapingDirectiveCode.execute();
    }

    public static final class FunctionNamePredicate {
        private Pattern namePattern;

        public void setPattern(String string) {
            String string2 = "\\Q" + string.replace("*", "\\E\\w+\\Q") + "\\E";
            this.namePattern = Pattern.compile(string2);
        }
    }

    public static final class FileRef {
        private final boolean isInput;
        private File file;

        public FileRef(boolean bl) {
            this.isInput = bl;
        }

        public void setPath(String string) throws IOException {
            this.file = new File(string);
            if (this.isInput) {
                if (!this.file.isFile() || !this.file.canRead()) {
                    throw new IOException("Missing input file " + string);
                }
            } else if (this.file.isDirectory() || !this.file.getParentFile().isDirectory()) {
                throw new IOException("Cannot write output file " + string);
            }
        }
    }
}

