/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Sets;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Set;
import java.util.SortedSet;

class FindCalleesNotInFileVisitor
extends AbstractSoyNodeVisitor<Set<String>> {
    private Set<String> templatesInFile;
    private SortedSet<String> calleesNotInFile;

    FindCalleesNotInFileVisitor() {
    }

    @Override
    public Set<String> exec(SoyNode soyNode) {
        this.visit(soyNode);
        return this.calleesNotInFile;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFileNode) {
        this.templatesInFile = Sets.newHashSet();
        for (TemplateNode templateNode : soyFileNode.getChildren()) {
            this.templatesInFile.add(templateNode.getTemplateName());
        }
        this.calleesNotInFile = Sets.newTreeSet();
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode callBasicNode) {
        String string = callBasicNode.getCalleeName();
        if (!this.templatesInFile.contains(string)) {
            this.calleesNotInFile.add(string);
        }
        this.visitChildren(callBasicNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

