/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.restricted;

import com.google.common.base.Joiner;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import java.util.regex.Pattern;

public class JavaCodeUtils {
    public static final String UTILS_LIB = "com.google.template.soy.javasrc.codedeps.SoyUtils";
    private static final Pattern NUMBER_IN_PARENS = Pattern.compile("^[(]([0-9]+(?:[.][0-9]+)?)[)]$");

    private JavaCodeUtils() {
    }

    public static String genMaybeProtect(JavaExpr javaExpr, int n) {
        return javaExpr.getPrecedence() >= n ? javaExpr.getText() : "(" + javaExpr.getText() + ")";
    }

    public static String genNewBooleanData(String string) {
        return "com.google.template.soy.data.restricted.BooleanData.forValue(" + string + ")";
    }

    public static String genNewIntegerData(String string) {
        return "com.google.template.soy.data.restricted.IntegerData.forValue(" + string + ")";
    }

    public static String genNewFloatData(String string) {
        return "com.google.template.soy.data.restricted.FloatData.forValue(" + string + ")";
    }

    public static String genNewStringData(String string) {
        return "com.google.template.soy.data.restricted.StringData.forValue(" + string + ")";
    }

    public static String genNewListData(String string) {
        return "new com.google.template.soy.data.SoyListData(" + string + ")";
    }

    public static String genNewMapData(String string) {
        return "new com.google.template.soy.data.SoyMapData(" + string + ")";
    }

    public static String genNewSanitizedContent(String string, SanitizedContent.ContentKind contentKind) {
        return "new " + SanitizedContent.class.getCanonicalName() + "(" + string + ", " + SanitizedContent.ContentKind.class.getCanonicalName() + "." + contentKind.name() + ")";
    }

    public static String genCoerceBoolean(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        if (string.startsWith("com.google.template.soy.data.restricted.BooleanData.forValue(")) {
            return string.substring("com.google.template.soy.data.restricted.BooleanData.forValue".length());
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".toBoolean()";
    }

    public static String genCoerceString(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        if (string.startsWith("com.google.template.soy.data.restricted.StringData.forValue(")) {
            return string.substring("com.google.template.soy.data.restricted.StringData.forValue".length());
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".toString()";
    }

    public static String genBooleanValue(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        if (string.startsWith("com.google.template.soy.data.restricted.BooleanData.forValue(")) {
            return string.substring("com.google.template.soy.data.restricted.BooleanData.forValue".length());
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".booleanValue()";
    }

    public static String genIntegerValue(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        if (string.startsWith("com.google.template.soy.data.restricted.IntegerData.forValue(")) {
            String string2 = string.substring("com.google.template.soy.data.restricted.IntegerData.forValue".length());
            if (NUMBER_IN_PARENS.matcher(string2).matches()) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".integerValue()";
    }

    public static String genFloatValue(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        if (string.startsWith("com.google.template.soy.data.restricted.FloatData.forValue(")) {
            String string2 = string.substring("com.google.template.soy.data.restricted.FloatData.forValue".length());
            if (NUMBER_IN_PARENS.matcher(string2).matches()) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".floatValue()";
    }

    public static String genNumberValue(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        String string2 = null;
        if (string.startsWith("com.google.template.soy.data.restricted.IntegerData.forValue(")) {
            string2 = string.substring("com.google.template.soy.data.restricted.IntegerData.forValue".length());
        }
        if (string.startsWith("com.google.template.soy.data.restricted.FloatData.forValue(")) {
            string2 = string.substring("com.google.template.soy.data.restricted.FloatData.forValue".length());
        }
        if (string2 != null) {
            if (NUMBER_IN_PARENS.matcher(string2).matches()) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".numberValue()";
    }

    public static String genStringValue(JavaExpr javaExpr) {
        String string = javaExpr.getText();
        if (string.startsWith("com.google.template.soy.data.restricted.StringData.forValue(")) {
            return string.substring("com.google.template.soy.data.restricted.StringData.forValue".length());
        }
        return JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".stringValue()";
    }

    public static String genMaybeCast(JavaExpr javaExpr, Class<? extends SoyData> clazz) {
        if (clazz.isAssignableFrom(javaExpr.getType())) {
            return javaExpr.getText();
        }
        return "(" + clazz.getName() + ") " + JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE);
    }

    public static String genConditional(String string, String string2, String string3) {
        return string + " ? " + string2 + " : " + string3;
    }

    public static boolean isAlwaysInteger(JavaExpr javaExpr) {
        return IntegerData.class.isAssignableFrom(javaExpr.getType());
    }

    public static boolean isAlwaysFloat(JavaExpr javaExpr) {
        return FloatData.class.isAssignableFrom(javaExpr.getType());
    }

    public static boolean isAlwaysString(JavaExpr javaExpr) {
        return StringData.class.isAssignableFrom(javaExpr.getType());
    }

    public static boolean isAlwaysNumber(JavaExpr javaExpr) {
        return NumberData.class.isAssignableFrom(javaExpr.getType());
    }

    public static boolean isAlwaysTwoIntegers(JavaExpr javaExpr, JavaExpr javaExpr2) {
        return JavaCodeUtils.isAlwaysInteger(javaExpr) && JavaCodeUtils.isAlwaysInteger(javaExpr2);
    }

    public static boolean isAlwaysTwoFloatsOrOneFloatOneInteger(JavaExpr javaExpr, JavaExpr javaExpr2) {
        return JavaCodeUtils.isAlwaysFloat(javaExpr) && JavaCodeUtils.isAlwaysNumber(javaExpr2) || JavaCodeUtils.isAlwaysFloat(javaExpr2) && JavaCodeUtils.isAlwaysNumber(javaExpr);
    }

    public static boolean isAlwaysAtLeastOneFloat(JavaExpr javaExpr, JavaExpr javaExpr2) {
        return JavaCodeUtils.isAlwaysFloat(javaExpr) || JavaCodeUtils.isAlwaysFloat(javaExpr2);
    }

    public static boolean isAlwaysAtLeastOneString(JavaExpr javaExpr, JavaExpr javaExpr2) {
        return JavaCodeUtils.isAlwaysString(javaExpr) || JavaCodeUtils.isAlwaysString(javaExpr2);
    }

    public static String genUnaryOp(String string, String string2) {
        return string + " " + string2;
    }

    public static String genBinaryOp(String string, String string2, String string3) {
        return string2 + " " + string + " " + string3;
    }

    public static String genFunctionCall(String string, String ... stringArray) {
        return string + "(" + Joiner.on((String)", ").join((Object[])stringArray) + ")";
    }

    public static JavaExpr genJavaExprForNumberToNumberBinaryFunction(String string, String string2, JavaExpr javaExpr, JavaExpr javaExpr2) {
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr, javaExpr2)) {
            String string3 = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genFunctionCall(string, JavaCodeUtils.genIntegerValue(javaExpr), JavaCodeUtils.genIntegerValue(javaExpr2)));
            return new JavaExpr(string3, IntegerData.class, Integer.MAX_VALUE);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(javaExpr, javaExpr2)) {
            String string4 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genFunctionCall(string, JavaCodeUtils.genFloatValue(javaExpr), JavaCodeUtils.genFloatValue(javaExpr2)));
            return new JavaExpr(string4, FloatData.class, Integer.MAX_VALUE);
        }
        String string5 = JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + string2, JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class), JavaCodeUtils.genMaybeCast(javaExpr2, NumberData.class));
        return new JavaExpr(string5, NumberData.class, Integer.MAX_VALUE);
    }
}

